/* $Id: HFLod.h,v 1.3 2002/10/12 00:58:46 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_HFLOD_H
#define ARK_HFLOD_H

#include <Modules/HeightField/ArkHeightField.h>
#include <Modules/HeightField/HFRender.h>

namespace Ark
{

   /// A specific type of world : an heightfieldLod (terrain)
   class ARKHEIGHTFIELD_DLL_API HeightFieldLod : public HeightFieldRender
   {
     protected:
     /// Levels
     ///   m_Depth = RoundToPreviousPowerOfTwo( min(HeightField::m_SizeX, HeightField::m_SizeY) );
     size_t m_Depth;

     /// The HF X and Z size
     ///   m_Size = 2^m_Depth + 1;
     size_t m_Size;

     /// Number of points
     ///   m_Points = m_Size^2;
     size_t m_Points;
     
     /// Per vertex data
     struct VertexLodData 
     {
	 scalar m_Error;   /// Maximum error
	 scalar m_Radius;  /// Influence radius

	 inline VertexLodData() {}
	 inline VertexLodData(scalar e, scalar r) : m_Error(e), m_Radius(r) {}

	 inline void set(scalar e, scalar r) 
	 { m_Error = e; m_Radius = r; }

     };

     VertexLodData* m_LodData;
     

     public:
     HeightFieldLod(HeightField* hf);

     /** Destroy the given HF */
     virtual ~HeightFieldLod();

     /// Render the height field (if the rendering system has been
     /// initialized of course)
     virtual void Render(Renderer &renderer, const Camera& camera);

     /** Read the heightfieldLod from the given directory.
      * \param path the name of the directory
      */
     virtual bool Load(const String &path);

     /** Write the heightfield to the given directory.
      * \param path the name of the directory
      * \param mipmaps true if mipmaps should be written (half size and
      *  quarter size versions are written, for less details => previews,
      * etc)
      */
     virtual bool Write (const String &path);

 protected:
     size_t FillVertexLodData(bool*, const int*, const int*, const int*, size_t);

   };

/* namespace Ark */
}

#endif
