/***************************************************************************
 $RCSfile: iniletter.cpp,v $
                             -------------------
    cvs         : $Id: iniletter.cpp,v 1.12 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sat Jan 26 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "iniletter.h"



string dumpHexString(string s) {
    string result;
    unsigned int pos;

    result+="   ";
    for (pos=0; pos<s.length(); pos++) {
        if ((pos & 31)==0)
            result+="\n   ";
        else if ((pos & 1)==0)
            result+=" ";
        result+=s.at(pos);
    } // for
    result+="\n";
    return result;
}


string makeTxtLetter(string hash,
                     string modulus,
                     string exponent,
                     int keyversion,
                     int keynumber,
                     string userid,
                     string sysid,
                     bool user,
                     bool usecrypt) {
    string result;
    string tmp;
    HBCI::DateTime tm;

    result="\n\n\nINI-Brief\n\n";
    if (user) {
        result+="Benutzername       : __________________________\n";
        result+="Datum              : ";
        tm=HBCI::DateTime::currentTime(false);
        tmp=tm.timeString("%D.%N.%Y");
        result+=tmp+"\n";
        tmp.erase();
        result+="Uhrzeit            : ";
        tmp=tm.timeString("%h:%m:%s");
        result+=tmp+"\n";
        result+="Benutzerkennung    : "+userid+"\n";
        result+="Schluesselnummer   : "+HBCI::String::num2string(keynumber)+"\n";
        result+="Schluesselversion  : "+HBCI::String::num2string(keyversion)+"\n";
        result+="Kundensystemkennung: "+sysid+"\n";
        result+="\n";

        result+="Oeffentlicher Schluessel fuer die elektronische Signatur\n\n";
        result+="  Exponent \n";

        if (exponent.length()<192)
            throw HBCI::Error("makeTxtLetter()",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "exponent too short");
        result+=dumpHexString(exponent);

        result+="\n";
        result+="  Modulus\n";
        if (exponent.length()<192)
            throw HBCI::Error("makeTxtLetter()",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "exponent too short");
        result+=dumpHexString(modulus);

        result+="\n";
        result+="  Hash\n";
        result+="\n";
        result+=dumpHexString(hash);

        result+="\n\n";
        result+="Ich bestaetige, dass ich den obigen Schluessel\n";
        result+="fuer meine elektronische Signatur ermittelt habe.\n";
        result+="\n\n";

        result+="_________________________  ____________________________\n";
        result+="Ort/Datum                  Unterschrift\n";
    }
    else {
        // server key
        result+="Datum              : ";
        tm=HBCI::DateTime::currentTime(false);
        tmp=tm.timeString("%D.%N.%Y");
        result+=tmp+"\n";
        tmp.erase();
        result+="Uhrzeit            : ";
        tmp=tm.timeString("%h:%m.%s");
        result+=tmp+"\n";
        result+="Institutskennung   : "+userid+"\n";
        result+="Kundensystemkennung: "+sysid+"\n";
        result+="\n";
        result+="Oeffentlicher Schluessel fuer die elektronische ";
        if (!usecrypt)
            result+="Signatur";
        else
            result+="Verschluesselung";
        result+="\n\n";
        result+="  Exponent \n";

        if (exponent.length()<192)
            throw HBCI::Error("makeTxtLetter()",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "exponent too short");
        result+=dumpHexString(exponent);

        result+="\n";
        result+="  Modulus\n";
        if (exponent.length()<192)
            throw HBCI::Error("makeTxtLetter()",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "exponent too short");
        result+=dumpHexString(modulus);

        result+="\n";
        result+="  Hash\n";
        result+=dumpHexString(hash);
    }
    return result;
}


string makeHTMLLetter(string hash,
                      string modulus,
                      string exponent,
                      int keyversion,
                      int keynumber,
                      string userid,
                      string sysid,
                      bool user,
                      bool usecrypt) {
    return "";
}



HBCI::Error iniletter(HBCI::Pointer<AQMAPI> hbciif,
		      HBCI::SimpleConfig &opt){
    int country;
    string instid;
    string userid;
    HBCI::Error err;
    HBCI::Pointer<HBCI::Medium> medium;
    HBCI::Pointer<HBCI::User> cust;
    HBCI::Pointer<HBCI::Bank> bank;
    string modulus;
    string exponent;
    string hash;
    int keyversion;
    int keynumber;
    string key;
    string result;
    bool isuser;
    string id;
    string tmp;
    bool usecrypt;
    string fname;
    HBCI::Pointer<HBCI::File> file;

    usecrypt=false;
    medium.setDescription("iniletter::medium (HBCI::Medium)");

    country=opt.getIntVariable("country",280,opt.root());
    instid=opt.getVariable("instid","",opt.root());
    userid=opt.getVariable("user","",opt.root());
    key=opt.getVariable("key","",opt.root());
    fname=opt.getVariable("outfile","",opt.root());

    if (country==0 ||
	instid.empty() ||
	userid.empty() ||
	key.empty())
      return HBCI::Error("iniletter()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "I need at least country,institute, key and user.");
    cust=hbciif.ref().findUser(country,
			       instid,
			       userid);
    if (!cust.isValid())
      return HBCI::Error("iniletter()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "user not found.");
    bank=cust.ref().bank();

    // get ini letter data
    try {
      medium=cust.ref().medium();
      if (medium.ref().securityMode()!=HBCI_SECURITY_RDH)
	return HBCI::Error("iniletter()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "not a RDH medium");

      // first mount medium
      err=medium.ref().mountMedium();
      if (!err.isOk())
	return HBCI::Error("iniletter()",err);

      // try to select the context
      err=medium.ref().selectContext(bank.ref().countryCode(),
				     bank.ref().bankCode(),
				     cust.ref().userId());
      if (!err.isOk()) {
	medium.ref().unmountMedium();
	return HBCI::Error("iniletter", err);
      }

      HBCI::Pointer<HBCI::MediumRDHBase> mediumrdh=
	medium.cast<HBCI::MediumRDHBase>();

      // get the iniletter stuff
      if (-1!=HBCI::parser::cmpPattern(key,"user",false)) {
	hash=mediumrdh.ref().getUserIniLetterHash();
	exponent=mediumrdh.ref().getUserIniLetterExponent();
	modulus=mediumrdh.ref().getUserIniLetterModulus();
	keynumber=mediumrdh.ref().getUserKeyNumber();
	keyversion=mediumrdh.ref().getUserKeyVersion();
	isuser=true;
	id=userid;
      } // if user
      else if (-1!=HBCI::parser::cmpPattern(key,"institute",false)) {
	// does the institute use signature keys ?
	usecrypt=!mediumrdh.ref().hasInstSignKey();
	hash=mediumrdh.ref().getInstIniLetterHash(usecrypt);
	exponent=mediumrdh.ref().getInstIniLetterExponent(usecrypt);
	modulus=mediumrdh.ref().getInstIniLetterModulus(usecrypt);
	keynumber=-1;
	keyversion=-1;
	isuser=false;
	id=instid;
      }  // if institute
      else {
	medium.ref().unmountMedium();
	return HBCI::Error("iniletter()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "bad value for key.");
      }

      // now we have all we need, unmount medium
      medium.ref().unmountMedium();

      // create text/html output
      tmp=opt.getVariable("output",
			  "txt",
			  opt.root());
      if (-1!=HBCI::parser::cmpPattern(tmp,
				       "html",
				       false))
	result=makeHTMLLetter(hash,
			      modulus,
			      exponent,
			      keyversion,
			      keynumber,
			      id,
                              "AqMoney " k_AQMONEY_VERSION_STRING,
			      isuser,
			      usecrypt);
      else
	result=makeTxtLetter(hash,
			     modulus,
			     exponent,
			     keyversion,
			     keynumber,
			     id,
			     "AqMoney " k_AQMONEY_VERSION_STRING,
			     isuser,
			     usecrypt);

      // if no output file name is given or the output file name is
      // a single dash, output the ini letter contents to stdout

      if ((fname.empty()) || (0 == strcmp ("-", fname.c_str()))){
	fprintf(stdout,"%s\n",result.c_str());
      }

      // else, output it to the file with the given name

      else {
	file = new HBCI::File (fname);
	err = file.ref ().createFile (FILE_AM_RDWR | FILE_AM_CREATE_ALWAYS);
	if (!err.isOk ())
	  return HBCI::Error ("iniletter", err);

	err = file.ref ().writeData (result);
	if (!err.isOk ()) {
	  file.ref ().closeFile();
	  return HBCI::Error ("iniletter", err);
	}

	err = file.ref ().closeFile();
	if (!err.isOk())
	  return HBCI::Error ("iniletter", err);
      }
    } // try
    catch (HBCI::Error lerr) {
      err=lerr;
    } // catch

    return err;
}



