/***************************************************************************
 $RCSfile: aqmprogressmonitor.h,v $
                             -------------------
    cvs         : $Id: aqmprogressmonitor.h,v 1.2 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Thu Apr 03 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef AQMPROGRESSMONITOR_H
#define AQMPROGRESSMONITOR_H


#include <openhbci.h>
#include "globals.h"
using namespace HBCI;


class AQMProgressMonitor: public HBCI::ProgressMonitor {
private:
  AQMAPI *_api;

public:
  AQMProgressMonitor(AQMAPI *api);
  virtual ~AQMProgressMonitor();

  /**
   * @short This method is called before starting a transaction.
   *
   * An example is when the outbox is executed: Before really doing
   * so, the AQMAPI calls this method to give this class the
   * opportunity to initialize a progress report.
   *
   * If you do not plan to give any kind of report to the user then you
   * have to overload this method with your version just doing nothing.
   * The default version of this method writes a short description to
   * stderr (for now, I guess I will later make this method do nothing.
   * So it is generally a good idea to overload this method).
   *
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param type Constant describing the type of action that is performed.
   * @param descr short description about what is to be done
   * @param jobs number of jobs to be performed. For example
   * @ref API::executeQueue gives here the number of jobs in the outbox plus
   * the number of customers affected multiplied by 2. This is because
   * when connecting to an institute we have two other additional jobs
   * to perform: opening the dialog and closing the dialog.  */
  virtual void transactionStarted(TransProgressType type,
				  string const &descr,
				  int jobs);

  /** @short This method is called after a transaction has finished.
   *
   * This method tells this class that the transaction is
   * finished. A derived class can use this to show the message
   * "finished" in the transaction window.
   *
   * @author Martin Preuss<martin@aquamaniac.de> */
  virtual void transactionFinished();

  /**
   * @short This method is called before a job starts.
   *
   * A derived class can use this to show in its progress window
   * what is currently done.
   *
   * Each job has one or more actions to perform, like sending data to
   * the server, receiving data from the server etc.
   *
   * If you do not plan to give any kind of report to the user then you
   * have to overload this method with your version just doing nothing.
   * The default version of this method writes a short description to
   * stderr (for now, I guess I will later make this method do nothing.
   * So it is generally a good idea to overload this method).
   *
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param type Constant describing the type of action that is performed.
   * @param descr short description of the job (like "Get Balance")
   * @param actions number of actions this job performs. This might be used
   * to draw a progress bar for a job.  */
  virtual void jobStarted(JobProgressType type,
			  const string &descr,
			  int actions);

  /**
   * @short This method is called after a job finished.
   *
   * Tells this class that the current job is finished. A derived
   * class can use this to advance the transactions progress bar.
   * @author Martin Preuss<martin@aquamaniac.de> */
  virtual void jobFinished();

  /**
   * @short This method is called before an action starts.
   *
   * Tells this class that an action starts, and what action is to
   * be performed now. A derived class can use this to show what is
   * currently done.
   *
   * If you do not plan to give any kind of report to the user then you
   * have to overload this method with your version just doing nothing.
   * The default version of this method writes a short description to
   * stderr (for now, I guess I will later make this method do nothing.
   * So it is generally a good idea to overload this method).
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param type Constant describing the type of action that is performed.
   * @param descr short description of what is to be done (like "sending
   * data to server").  */
  virtual void actionStarted(ActionProgressType type,
			     const string &descr);

  /**
   * @short This method is called after an action finshed.
   *
   * Tells this class that an action finished, i.e. the current
   * action is done. A derived class can use this to advance the
   * current job's progress bar, or to write the message "done" into
   * the appropriate line of its progress report window.
   *
   * @author Martin Preuss<martin@aquamaniac.de> */
  virtual void actionFinished();

  /** @short DEPRECATED. This method is not used inside OpenHBCI.
   *
   * This method was meant to be called to log a message, but <i>it
   * is not used from inside OpenHBCI</i>. It may or may not
   * disappear in future releases.
   *
   * The only method to log messages in OpenHBCI is the
   * HBCI::Interactor::msgStateResponse() method.
   *
   * The default version of this method writes a short description to
   * stderr (for now, I guess I will later make this method do nothing.).
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param msg msg to show */
  virtual void logMessage(const string &msg);

};


#endif





