/*
 * libax25ext.c: Some added functions for libax25.  Conditionally
 *  compiled only if the installed libax25 has not integrated them.
 *  Copyright (c) 1999 E. Alan Crosswell, N2YGK
 */

#ifndef HAVE_LIBAX25_EXTENSIONS
#define	ALEN		6
#define	AXLEN		7
#define	HDLCAEB		0x01
#define	REPEATED	0x80
#define	UI		0x03	/* unnumbered information (unproto) */
#define	PID_NO_L3	0xF0	/* no level-3 */

/*
 * parse a received kiss data frame into ax_calls and update data pointer
 *  and length next byte of frame.  Returns -1 on invalid or non-UI frame, 0
 *  on valid frame, 1 on valid frame that still has a non-repeated digi.
 */

pk_val
parse_kiss(unsigned char **frame, int *len, struct ax_calls *calls)
{
  if ((**frame & 0xf) != 0 || *len < 1+(2*AXLEN))
    return PK_INVALID;		/* not a valid kiss data frame */
  ++*frame;
  --*len;
  bzero(calls,sizeof(*calls));
  calls->ax_next_digi = 0;
  bcopy(*frame,calls->ax_to_call.ax25_call,AXLEN);
  *frame += AXLEN;
  *len -= AXLEN;
  bcopy(*frame,calls->ax_from_call.ax25_call,AXLEN);
  *frame += AXLEN;
  *len -= AXLEN;
  if (*len <= 0)
    return PK_VALID;
  if (!(calls->ax_from_call.ax25_call[ALEN] & HDLCAEB))	{ /* digis listed */
    for (calls->ax_n_digis = 0; 
	 calls->ax_n_digis < AX25_MAX_DIGIS && *len > 0; 
	 calls->ax_n_digis++, *len-=AXLEN,*frame+=AXLEN) {
      bcopy(*frame,calls->ax_digi_call[calls->ax_n_digis].ax25_call,AXLEN);
      if ((*frame)[ALEN]&REPEATED)
	calls->ax_next_digi = calls->ax_n_digis+1;
      if ((*frame)[ALEN]&HDLCAEB) { /* last digi */
	*frame += AXLEN;
	*len -= AXLEN;
	++calls->ax_n_digis;
	break;
      }
    }
  }
  if (--*len >= 0)
    calls->ax_type = *(*frame)++;
  if (--*len >= 0)
    calls->ax_pid = *(*frame)++;
  if (!(calls->ax_type == UI && calls->ax_pid == PID_NO_L3))
    return PK_INVALID;		/* not a UI text frame */
  if (calls->ax_n_digis == 0
      || calls->ax_next_digi > calls->ax_n_digis) /* all digis used up */
    return PK_VALID;
  else
    return PK_VALDIGI;
}

/* reverse of parse_kiss: generates a kiss frame */
int
gen_kiss(unsigned char **frame, int *len, struct ax_calls *calls)
{
  int minsize = 1+AXLEN+AXLEN+(calls->ax_n_digis*AXLEN)+2;
  int i;
  
  if (*len < minsize)
    return -1;
  *len -= minsize;
  if (calls->ax_n_digis == 0)
    calls->ax_from_call.ax25_call[ALEN] |= HDLCAEB;
  else
    calls->ax_from_call.ax25_call[ALEN] &= ~HDLCAEB;

  *(*frame)++ = '\0';		/* KISS type 0 */
  bcopy(calls->ax_to_call.ax25_call,*frame,AXLEN);
  *frame += AXLEN;
  bcopy(calls->ax_from_call.ax25_call,*frame,AXLEN);
  *frame += AXLEN;
  for (i = 0; i < calls->ax_n_digis; i++,*frame += AXLEN) {
    calls->ax_digi_call[i].ax25_call[ALEN] &= ~HDLCAEB;
    bcopy(calls->ax_digi_call[i].ax25_call,*frame,AXLEN);
  }    
  if (i > 0)
    *(*frame-AXLEN+ALEN) |= HDLCAEB;
  *(*frame)++ = calls->ax_type;
  *(*frame)++ = calls->ax_pid;
  return 0;
}
#endif


