/***************************************************************************
                          ApollonSharedViewTab.h  -  description
                             -------------------
begin		: June 05 2003
copyright	: (C) 2003 Martin Koebele
email		: apollon@mkoebele.de
description	:

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APOLLONSHAREDVIEW_H
#define APOLLONSHAREDVIEW_H

#include <kparts/part.h>

#include "apollontab.h"

class KImageFilePreview;
class KFileTreeView;
class KFileTreeViewItem;
class KPopupMenu;

class QButton;
class QLabel;
class QString;
class QStringList;
class QListViewItem;

class ApollonPlayerTab;

class ApollonSharedViewTab : public ApollonTab
{
	Q_OBJECT

	public:
		ApollonSharedViewTab(QWidget *parent, const QString &name);
		~ApollonSharedViewTab();

		void setPlayerTab(ApollonPlayerTab *playerTab) { m_playerTab = playerTab; };

	public slots:
		void addFolder(const QString &folder);
		void doubleClicked(QListViewItem *item, const QPoint &point, int col);
		void popUp(QListViewItem *item, const QPoint &point, int col);
		void playFile();
		void addFileToXMMS();
		void addFileToJuK();
		void addFileToAmarok();
		void deleteFile();
		void renameFile();

	signals:
		void syncShares();

	protected:
		KFileTreeView *m_listView;

	private:
		QLabel *m_iconLabel;
		QLabel *m_label;
		QButton *m_syncButton;

		KPopupMenu *m_popupMenu;
		KPopupMenu *m_moveToMenu;

		KFileTreeViewItem *m_currentItem;
		KImageFilePreview *m_kpv;
		ApollonPlayerTab  *m_playerTab;
		int                m_id;
		bool isRunning(QString);

	private slots:
		void play(KFileTreeViewItem *item);
		void rename(QListViewItem *item, int col);
		void moveTo(int id);
		void preview(QListViewItem *item);
};

#endif
