/***************************************************************************
                          apollon.h -  description
                             -------------------
begin		: Dec 05 2003
copyright	: (C) 2002 by Bastiaan Naber, (C) 2002 by Robert Wittams
email		: bastiaan@ricardis.tudelft.nl
description	:

 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APOLLON_H
#define APOLLON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>

#include <kaction.h>
#include <kmainwindow.h>
#include "apolloniface.h"

class KJanusWidget;

class QLabel;

class ApollonInfoTab;
class ApollonPlayerTab;
class ApollonPreferencesDialog;
class ApollonSearchTab;
class ApollonSharedViewTab;
class ApollonSystemTray;
class ApollonTransferTab;
class ApollonChatTab;
class giFTConnection;
class SigDialog;

class ApollonApp : public KMainWindow, virtual public ApollonIface
{
	Q_OBJECT

	public:
		ApollonApp(QWidget *parent = 0, const char *name = 0);
		~ApollonApp();

		void readConfig();

		bool startDocked() { return m_startDocked; };

	public slots:
		void saveConfig();

		void sharesSync();
		void sharesHide();
		void sharesShow();

		void giftShareReply(QString reply);

		void setGiFTpid(pid_t pid);
		void setKillGiFT(bool killGiFT);
		void setStatus(QString text);
		void statsUpdate(int activeDownloads, float rate);

		void quit();
		void configureShortcuts();
	
	protected:
		bool queryClose();
		static void safePlug( KActionCollection *ac, const char *name, QWidget *w );

	private:
		giFTConnection *m_gcn;
		KJanusWidget   *m_tabWidget;

		ApollonInfoTab       *m_infoTab;
		ApollonSearchTab     *m_searchTab;
		ApollonTransferTab   *m_transTab;
		ApollonPlayerTab     *m_playerTab;
		ApollonSharedViewTab *m_sharedViewTab;
		ApollonChatTab   *m_chatTab;

		ApollonSystemTray        *m_systemTray;
		ApollonPreferencesDialog *m_settingsDialog;
		KToggleAction            *m_toggleSystemTrayAction;
		pid_t                     m_giFTpid;
		SigDialog                *m_sigDialog;
		QLabel                   *m_statsLabel;

		bool m_restore;
		bool m_shutdown;
		bool m_killGiFT;
		bool m_startDocked;
		bool m_uploadsEnabled;

		void initStatusBar();
		void initActions();
		void initCentre();
		
		

	private slots:
		void setShutdownApollon(bool shutdown) { m_shutdown = shutdown; }
		void setStartDocked(bool startDocked)  { m_startDocked = startDocked; }
		void setShowPopUps(int show);
		void setStartPage(int page);
		void showSearches(QString);
                void initSysTray(bool);
		void setProgressBarType(int type);

	signals:
		
};

#endif
