#ifndef SIGDIALOG_H
#define SIGDIALOG_H

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
#include "giftconnection.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QLabel;
class QLineEdit;
class QPushButton;

class SigDialog : public QDialog
{
    Q_OBJECT

public:
    SigDialog( giFTConnection * gcn,QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~SigDialog();

    QLabel* textLabel;
    QLineEdit* lineEdit;
    QLabel* pixmapLabel4;
    QLabel* textLabel2;
    QPushButton* okButton;
    QPushButton* cancelButton;
    giFTConnection* _gcn;

    virtual QString dectobin( int input );
    virtual QString bintohex( QString bin );

public slots:
    virtual void addItem();

signals:
    void giftAddRequest( QString, QString, QString, QString, QString );

protected:
    QGridLayout* SigDialogLayout;
    QVBoxLayout* layout6;
    QHBoxLayout* layout1;
    QHBoxLayout* layout4;
    QHBoxLayout* layout3;

protected slots:
    virtual void languageChange();
private:
    QPixmap image0;

};

#endif // SIGDIALOG_H
