#include <apache2/httpd.h>
#include <apache2/http_config.h>
#include <apache2/http_request.h>
#include <apache2/http_protocol.h>
#include <apache2/http_log.h>

#include <apr-0/apr_strings.h>
#include <apr-0/apr_tables.h>

#ifdef __GNUC__
#define UNUSED __attribute__((unused))
#else
#define UNUSED
#endif

struct config {
	int enabled;
};

typedef struct config config;

module redir_to_servname_module;

static void *create_config(apr_pool_t *p, server_rec *s UNUSED) {
	config *cfg = (config *)apr_pcalloc(p, sizeof(config));
	cfg->enabled = 0;
	return (void *)cfg;
}

static const char *set_enabled(cmd_parms *cmd, void *dummy UNUSED, int on) {
	config *cfg = (config *)ap_get_module_config(
			cmd->server->module_config,
			&redir_to_servname_module);
	cfg->enabled = on;
	return NULL;
}

static int canonicalize_hostname(request_rec *r) {
	const config *cfg = (const config *)ap_get_module_config(
			r->server->module_config,
			&redir_to_servname_module);
	if(!cfg->enabled)
		return DECLINED;

	const char *cname = r->server->server_hostname;
	const char *rname = r->hostname;

	if(!strcmp(cname, rname))
		return DECLINED;

	apr_uri_t uri;
	if(apr_uri_parse(r->pool, r->unparsed_uri, &uri) != APR_SUCCESS)
		return DECLINED;

	uri.scheme = (char *)ap_http_method(r);
	uri.hostname = (char *)cname;

	char *redirect = apr_uri_unparse(r->pool, &uri, APR_URI_UNP_OMITUSERINFO);
	ap_log_error(__FILE__, __LINE__, APLOG_WARNING, 0, r->server, "Redirecting to %s", redirect);
	apr_table_setn(r->headers_out, "Location", redirect);
	return HTTP_MOVED_PERMANENTLY;
}

static void register_hooks(apr_pool_t *p UNUSED) {
	ap_hook_access_checker(canonicalize_hostname, NULL, NULL, APR_HOOK_FIRST);
}

static const command_rec cmds[] = {
	AP_INIT_FLAG("RedirectToServerName", set_enabled, NULL, RSRC_CONF,
		"RedirectToServerName must be either \"On\" or \"Off\"."),
	{NULL, NULL, NULL, 0, 0, NULL}
};

module AP_MODULE_DECLARE_DATA redir_to_servname_module = {
	STANDARD20_MODULE_STUFF,
	NULL,
	NULL,
	create_config,
	NULL,
	cmds,
	register_hooks
};


