;; anthy-azik.el

;; Copyright (C) 2004
;; Author: Yutaka Hara<yhara@kmc.gr.jp>

(defvar anthy-azik-mode-hiragana-map
  '(
    (";" . "$B$C(B")  ("x;" . ";")  ("b." . "$B$V(B")  ("bd" . "$B$Y$s(B")  ("bh" . "$B$V$&(B")  
    ("bj" . "$B$V$s(B")  ("bk" . "$B$S$s(B")  ("bl" . "$B$$(Bs")  ("bn" . "$B$P$s(B")  ("bp" . "$B$$(B&")  
    ("bq" . "$B$P$$(B")  ("br" . "$B$P$i(B")  ("bt" . "$B$S$H(B")  ("bw" . "$B$Y$$(B")  ("bx" . "$B$Y$$(B")  
    ("byd" . "$B$S$'$s(B")  ("byh" . "$B$S$e$&(B")  ("byj" . "$B$S$e$s(B")  ("byl" . "$B$S$g$s(B")  ("byn" . "$B$S$c$s(B")  
    ("byp" . "$B$S$g$&(B")  ("byq" . "$B$S$c$$(B")  ("byw" . "$B$S$'$$(B")  ("byz" . "$B$S$c$s(B")  ("bz" . "$B$P$s(B")  
    ("ca" . "$B$A$c(B")  ("cc" . "$B$A$c(B")  ("cd" . "$B$A$'$s(B")  ("ce" . "$B$A$'(B")  ("cf" . "$B$A$'(B")  
    ("ch" . "$B$A$e$&(B")  ("ci" . "$B$A(B")  ("cj" . "$B$A$e$s(B")  ("ck" . "$B$A$s(B")  ("cl" . "$B$A$g$s(B")  
    ("cn" . "$B$A$c$s(B")  ("co" . "$B$A$g(B")  ("cp" . "$B$A$g$&(B")  ("cq" . "$B$A$c$$(B")  ("cu" . "$B$A$e(B")  
    ("cv" . "$B$A$c$$(B")  ("cw" . "$B$A$'$$(B")  ("cx" . "$B$A$'$$(B")  ("cz" . "$B$A$c$s(B")  ("dch" . "$B$G$e!<(B")  
    ("dci" . "$B$G$#(B")  ("dck" . "$B$G(B$")  ("dcp" . "$B$I$%!<(B")  ("dcu" . "$B$G$e(B")  ("dd" . "$B$G$s(B")  
    ("df" . "$B$G(B")  ("dg" . "$B$@$,(B")  ("dh" . "$B$E$&(B")  ("dj" . "$B$E$s(B")  ("dk" . "$B$B$s(B")  
    ("dl" . "$B$I$s(B")  ("dm" . "$B$G$b(B")  ("dn" . "$B$@$s(B")  ("dp" . "$B$I$&(B")  ("dq" . "$B$@$$(B")  
    ("dr" . "$B$G$"$k(B")  ("ds" . "$B$G$9(B")  ("dt" . "$B$@$A(B")  ("dv" . "$B$G$s(B")  ("dw" . "$B$G$$(B")  
    ("dy" . "$B$G$#(B")  ("dz" . "$B$@$s(B")  ("fd" . "$B$U$'$s(B")  ("fh" . "$B$U$&(B")  ("fj" . "$B$U$s(B")  
    ("fk" . "$B$U(B$")  ("fl" . "$B$U$)$s(B")  ("fm" . "$B$U$`(B")  ("fn" . "$B$U$!$s(B")  ("fp" . "$B$U$)!<(B")  
    ("fq" . "$B$U$!$$(B")  ("fr" . "$B$U$k(B")  ("fs" . "$B$U$!$$(B")  ("fw" . "$B$U$'$$(B")  ("fz" . "$B$U$!$s(B")  
    ("gd" . "$B$2$s(B")  ("gh" . "$B$0$&(B")  ("gj" . "$B$0$s(B")  ("gk" . "$B$.$s(B")  ("gl" . "$B$4$s(B")  
    ("gn" . "$B$,$s(B")  ("gp" . "$B$4$&(B")  ("gq" . "$B$,$$(B")  ("gr" . "$B$,$i(B")  ("gt" . "$B$4$H(B")  
    ("gw" . "$B$2$$(B")  ("gyd" . "$B$.$'$s(B")  ("gyh" . "$B$.$e$&(B")  ("gyj" . "$B$.$e$s(B")  ("gyl" . "$B$.$g$s(B")  
    ("gyn" . "$B$.$c$s(B")  ("gyp" . "$B$.$g$&(B")  ("gyq" . "$B$.$c$$(B")  ("gyw" . "$B$.$'$$(B")  ("gyz" . "$B$.$c$s(B")  
    ("gz" . "$B$,$s(B")  ("hd" . "$B$X$s(B")  ("hf" . "$B$U(B")  ("hga" . "$B$R$c(B")  ("hgd" . "$B$R$'$s(B")  
    ("hge" . "$B$R$'(B")  ("hgh" . "$B$R$e$&(B")  ("hgj" . "$B$R$e$s(B")  ("hgl" . "$B$R$g$s(B")  ("hgn" . "$B$R$c$s(B")  
    ("hgo" . "$B$R$g(B")  ("hgp" . "$B$R$g$&(B")  ("hgq" . "$B$R$c$$(B")  ("hgu" . "$B$R$e(B")  ("hgw" . "$B$R$'$$(B")  
    ("hgz" . "$B$R$c$s(B")  ("hh" . "$B$U$&(B")  ("hj" . "$B$U$s(B")  ("hk" . "$B$R$s(B")  ("hl" . "$B$[$s(B")  
    ("hn" . "$B$O$s(B")  ("hp" . "$B$[$&(B")  ("hq" . "$B$O$$(B")  ("ht" . "$B$R$H(B")  ("hw" . "$B$X$$(B")  
    ("hyd" . "$B$R$'$s(B")  ("hyh" . "$B$R$e$&(B")  ("hyl" . "$B$R$g$s(B")  ("hyp" . "$B$R$g$&(B")  ("hyq" . "$B$R$c$$(B")  
    ("hyw" . "$B$R$'$$(B")  ("hyz" . "$B$R$c$s(B")  ("hz" . "$B$O$s(B")  ("jd" . "$B$8$'$s(B")  ("jf" . "$B$8$e(B")  
    ("jh" . "$B$8$e$&(B")  ("jj" . "$B$8$e$s(B")  ("jk" . "$B$8$s(B")  ("jl" . "$B$8$g$s(B")  ("jn" . "$B$8$c$s(B")  
    ("jp" . "$B$8$g$&(B")  ("jq" . "$B$8$c$$(B")  ("jv" . "$B$8$e$&(B")  ("jw" . "$B$8$'$$(B")  ("jz" . "$B$8$c$s(B")  
    ("kA" . "$B%u(B")  ("kE" . "$B%v(B")  ("kd" . "$B$1$s(B")  ("kf" . "$B$-(B")  ("kga" . "$B$-$c(B")  
    ("kgd" . "$B$-$'$s(B")  ("kge" . "$B$-$'(B")  ("kgh" . "$B$-$e$&(B")  ("kgl" . "$B$-$g$s(B")  ("kgn" . "$B$-$c$s(B")  
    ("kgo" . "$B$-$g(B")  ("kgp" . "$B$-$g$&(B")  ("kgq" . "$B$-$c$$(B")  ("kgu" . "$B$-$e(B")  ("kgw" . "$B$-$'$$(B")  
    ("kgz" . "$B$-$c$s(B")  ("kh" . "$B$/$&(B")  ("kj" . "$B$/$s(B")  ("kk" . "$B$-$s(B")  ("kl" . "$B$3$s(B")  
    ("km" . "$B$-(B")  ("kn" . "$B$+$s(B")  ("kp" . "$B$3$&(B")  ("kq" . "$B$+$$(B")  ("kr" . "$B$+$i(B")  
    ("kt" . "$B$3$H(B")  ("kv" . "$B$-$s(B")  ("kw" . "$B$1$$(B")  ("kyd" . "$B$-$'$s(B")  ("kyh" . "$B$-$e$&(B")  
    ("kyj" . "$B$-$e$s(B")  ("kyl" . "$B$-$g$s(B")  ("kyn" . "$B$-$c$s(B")  ("kyp" . "$B$-$g$&(B")  ("kyq" . "$B$-$c$$(B")  
    ("kyw" . "$B$-$'$$(B")  ("kyz" . "$B$-$c$s(B")  ("kz" . "$B$+$s(B")  ("m." . "$B$`(B")  ("md" . "$B$a$s(B")  
    ("mf" . "$B$`(B")  ("mga" . "$B$_$c(B")  ("mgd" . "$B$_$'$s(B")  ("mge" . "$B$_$'(B")  ("mgh" . "$B$_$e$&(B")  
    ("mgj" . "$B$_$e$s(B")  ("mgl" . "$B$_$g$s(B")  ("mgn" . "$B$_$c$s(B")  ("mgo" . "$B$_$g(B")  ("mgp" . "$B$_$g$&(B")  
    ("mgq" . "$B$_$c$$(B")  ("mgu" . "$B$_$e(B")  ("mgw" . "$B$_$'$$(B")  ("mgz" . "$B$_$c$s(B")  ("mh" . "$B$`$&(B")  
    ("mj" . "$B$`$s(B")  ("mk" . "$B$_$s(B")  ("ml" . "$B$b$s(B")  ("mn" . "$B$b$N(B")  ("mp" . "$B$b$&(B")  
    ("mq" . "$B$^$$(B")  ("mr" . "$B$^$k(B")  ("ms" . "$B$^$9(B")  ("mt" . "$B$^$?(B")  ("mv" . "$B$`$s(B")  
    ("mw" . "$B$a$$(B")  ("myd" . "$B$_$'$s(B")  ("myh" . "$B$_$e$&(B")  ("myj" . "$B$_$e$s(B")  ("myl" . "$B$_$g$s(B")  
    ("myn" . "$B$_$c$s(B")  ("myp" . "$B$_$g$&(B")  ("myq" . "$B$_$c$$(B")  ("myw" . "$B$_$'$$(B")  ("myz" . "$B$_$c$s(B")  
    ("mz" . "$B$^$s(B")  ("n." . "$B$L(B")  ("nb" . "$B$M$P(B")  ("nd" . "$B$M$s(B")  ("nf" . "$B$L(B")  
    ("nga" . "$B$K$c(B")  ("ngd" . "$B$K$'$s(B")  ("nge" . "$B$K$'(B")  ("ngh" . "$B$K$e$&(B")  ("ngj" . "$B$K$e$s(B")  
    ("ngl" . "$B$K$g$s(B")  ("ngn" . "$B$K$c$s(B")  ("ngo" . "$B$K$g(B")  ("ngp" . "$B$K$g$&(B")  ("ngq" . "$B$K$c$$(B")  
    ("ngu" . "$B$K$e(B")  ("ngw" . "$B$K$'$$(B")  ("ngz" . "$B$K$c$s(B")  ("nh" . "$B$L$&(B")  ("nj" . "$B$L$s(B")  
    ("nk" . "$B$K$s(B")  ("nl" . "$B$N$s(B")  ("np" . "$B$N$&(B")  ("nq" . "$B$J$$(B")  ("nr" . "$B$J$k(B")  
    ("nt" . "$B$K$A(B")  ("nv" . "$B$L$s(B")  ("nw" . "$B$M$$(B")  ("nyd" . "$B$K$'$s(B")  ("nyh" . "$B$K$e$&(B")  
    ("nyj" . "$B$K$e$s(B")  ("nyl" . "$B$K$g$s(B")  ("nyn" . "$B$K$c$s(B")  ("nyp" . "$B$K$g$&(B")  ("nyq" . "$B$K$c$$(B")  
    ("nyw" . "$B$K$'$$(B")  ("nyz" . "$B$K$c$s(B")  ("nz" . "$B$J$s(B")  ("pd" . "$B$Z$s(B")  ("pf" . "$B$]$s(B")  
    ("pga" . "$B$T$c(B")  ("pgd" . "$B$T$'$s(B")  ("pge" . "$B$T$'(B")  ("pgh" . "$B$T$e$&(B")  ("pgj" . "$B$T$e$s(B")  
    ("pgl" . "$B$T$g$s(B")  ("pgn" . "$B$T$c$s(B")  ("pgo" . "$B$T$g(B")  ("pgp" . "$B$T$g$&(B")  ("pgq" . "$B$T$c$$(B")  
    ("pgu" . "$B$T$e(B")  ("pgw" . "$B$T$'$$(B")  ("pgz" . "$B$T$c$s(B")  ("ph" . "$B$W$&(B")  ("pj" . "$B$W$s(B")  
    ("pk" . "$B$T$s(B")  ("pl" . "$B$]$s(B")  ("pn" . "$B$Q$s(B")  ("pp" . "$B$]$&(B")  ("pq" . "$B$Q$$(B")  
    ("pv" . "$B$]$&(B")  ("pw" . "$B$Z$$(B")  ("pyd" . "$B$T$'$s(B")  ("pyh" . "$B$T$e$&(B")  ("pyj" . "$B$T$e$s(B")  
    ("pyl" . "$B$T$g$s(B")  ("pyn" . "$B$T$c$s(B")  ("pyp" . "$B$T$g$&(B")  ("pyq" . "$B$T$c$$(B")  ("pyw" . "$B$T$'$$(B")  
    ("pyz" . "$B$T$c$s(B")  ("pz" . "$B$Q$s(B")  ("q" . "$B$s(B")  ("rd" . "$B$l$s(B")  ("rh" . "$B$k$&(B")  
    ("rj" . "$B$k$s(B")  ("rk" . "$B$j$s(B")  ("rl" . "$B$m$s(B")  ("rn" . "$B$i$s(B")  ("rp" . "$B$m$&(B")  
    ("rq" . "$B$i$$(B")  ("rr" . "$B$i$l(B")  ("rw" . "$B$l$$(B")  ("ryd" . "$B$j$'$s(B")  ("ryh" . "$B$j$e$&(B")  
    ("ryj" . "$B$j$e$s(B")  ("ryk" . "$B$j$g$/(B")  ("ryl" . "$B$j$g$s(B")  ("ryn" . "$B$j$c$s(B")  ("ryp" . "$B$j$g$&(B")  
    ("ryq" . "$B$j$c$$(B")  ("ryw" . "$B$j$'$$(B")  ("ryz" . "$B$j$c$s(B")  ("rz" . "$B$i$s(B")  ("sd" . "$B$;$s(B")  
    ("sf" . "$B$5$$(B")  ("sh" . "$B$9$&(B")  ("sj" . "$B$9$s(B")  ("sk" . "$B$7$s(B")  ("sl" . "$B$=$s(B")  
    ("sm" . "$B$7$b(B")  ("sn" . "$B$5$s(B")  ("sp" . "$B$=$&(B")  ("sq" . "$B$5$$(B")  ("sr" . "$B$9$k(B")  
    ("ss" . "$B$;$$(B")  ("st" . "$B$7$?(B")  ("sv" . "$B$5$$(B")  ("sw" . "$B$;$$(B")  ("syd" . "$B$7$'$s(B")  
    ("syh" . "$B$7$e$&(B")  ("syj" . "$B$7$e$s(B")  ("syl" . "$B$7$g$s(B")  ("syp" . "$B$7$g$&(B")  ("syq" . "$B$7$c$$(B")  
    ("syw" . "$B$7$'$$(B")  ("syz" . "$B$7$c$s(B")  ("sz" . "$B$5$s(B")  ("tU" . "$B$C(B")  ("tb" . "$B$?$S(B")  
    ("td" . "$B$F$s(B")  ("tgh" . "$B$F$e!<(B")  ("tgi" . "$B$F$#(B")  ("tgk" . "$B$F(B$")  ("tgp" . "$B$H$%!<(B")  
    ("tgu" . "$B$F$e(B")  ("th" . "$B$D$&(B")  ("tj" . "$B$D$s(B")  ("tk" . "$B$A$s(B")  ("tl" . "$B$H$s(B")  
    ("tm" . "$B$?$a(B")  ("tn" . "$B$?$s(B")  ("tp" . "$B$H$&(B")  ("tq" . "$B$?$$(B")  ("tr" . "$B$?$i(B")  
    ("tsU" . "$B$C(B")  ("tsa" . "$B$D$!(B")  ("tse" . "$B$D$'(B")  ("tsi" . "$B$D$#(B")  ("tso" . "$B$D$)(B")  
    ("tt" . "$B$?$A(B")  ("tw" . "$B$F$$(B")  ("tyd" . "$B$A$'$s(B")  ("tyh" . "$B$A$e$&(B")  ("tyj" . "$B$A$e$s(B")  
    ("tyl" . "$B$A$g$s(B")  ("tyn" . "$B$A$c$s(B")  ("typ" . "$B$A$g$&(B")  ("tyq" . "$B$A$c$$(B")  ("tyw" . "$B$A$'$$(B")  
    ("tyz" . "$B$A$c$s(B")  ("tz" . "$B$?$s(B")  ("vd" . "$B$&!+$'$s(B")  ("vk" . "$B$&!+(B$")  ("vl" . "$B$&!+$)$s(B")  
    ("vn" . "$B$&!+$!$s(B")  ("vp" . "$B$&!+$)!<(B")  ("vq" . "$B$&!+$!$$(B")  ("vw" . "$B$&!+$'$$(B")  ("vya" . "$B$&!+$c(B")  
    ("vye" . "$B$&!+$'(B")  ("vyo" . "$B$&!+$g(B")  ("vyu" . "$B$&!+$e(B")  ("vz" . "$B$&!+$!$s(B")  ("wA" . "$B$n(B")  
    ("wd" . "$B$&$'$s(B")  ("wf" . "$B$o(B")  ("wha" . "$B$&$!(B")  ("whe" . "$B$&$'(B")  ("whi" . "$B$&$#(B")  
    ("who" . "$B$&$)(B")  ("whu" . "$B$&(B")  ("wk" . "$B$&(B$")  ("wl" . "$B$&$)$s(B")  ("wn" . "$B$o$s(B")  
    ("wp" . "$B$&$)!<(B")  ("wq" . "$B$o$$(B")  ("wr" . "$B$o$l(B")  ("wso" . "$B$&$)(B")  ("wt" . "$B$o$?(B")  
    ("wz" . "$B$o$s(B")  ("xa" . "$B$7$c(B")  ("xc" . "$B$7$c(B")  ("xd" . "$B$7$'$s(B")  ("xe" . "$B$7$'(B")  
    ("xf" . "$B$7$'$$(B")  ("xh" . "$B$7$e$&(B")  ("xi" . "$B$7(B")  ("xj" . "$B$7$e$s(B")  ("xk" . "$B$7$s(B")  
    ("xl" . "$B$7$g$s(B")  ("xn" . "$B$7$c$s(B")  ("xo" . "$B$7$g(B")  ("xp" . "$B$7$g$&(B")  ("xq" . "$B$7$c$$(B")  
    ("xt" . "$B$7$e$D(B")  ("xu" . "$B$7$e(B")  ("xv" . "$B$7$c$$(B")  ("xw" . "$B$7$'$$(B")  ("xxa" . "$B$!(B")  
    ("xxe" . "$B$'(B")  ("xxi" . "$B$#(B")  ("xxo" . "$B$)(B")  ("xxu" . "$B$%(B")  ("xxh" . "$B"+(B")  
    ("xxj" . "$B"-(B")  ("xxk" . "$B",(B")  ("xxl" . "$B"*(B")  ("xz" . "$B$7$c$s(B")  ("y<" . "$B"+(B")  
    ("y>" . "$B"*(B")  ("y^" . "$B",(B")  ("yf" . "$B$f(B")  ("yh" . "$B$f$&(B")  ("yi" . "$B$p(B")  
    ("yj" . "$B$f$s(B")  ("yl" . "$B$h$s(B")  ("yn" . "$B$d$s(B")  ("yp" . "$B$h$&(B")  ("yq" . "$B$d$$(B")  
    ("yr" . "$B$h$k(B")  ("yv" . "$B$f$&(B")  ("yz" . "$B$d$s(B")  ("z." . "$B$:(B")  ("zc" . "$B$6(B")  
    ("zd" . "$B$<$s(B")  ("zf" . "$B$<(B")  ("zh" . "$B$:$&(B")  ("zj" . "$B$:$s(B")  ("zk" . "$B$8$s(B")  
    ("zl" . "$B$>$s(B")  ("zn" . "$B$6$s(B")  ("zp" . "$B$>$&(B")  ("zq" . "$B$6$$(B")  ("zr" . "$B$6$k(B")  
    ("zv" . "$B$6$$(B")  ("zw" . "$B$<$$(B")  ("zx" . "$B$<$$(B")  ("zyd" . "$B$8$'$s(B")  ("zyh" . "$B$8$e$&(B")  
    ("zyj" . "$B$8$e$s(B")  ("zyl" . "$B$8$g$s(B")  ("zyn" . "$B$8$c$s(B")  ("zyp" . "$B$8$g$&(B")  ("zyq" . "$B$8$c$$(B")  
    ("zyw" . "$B$8$'$$(B")  ("zyz" . "$B$8$c$s(B")  ("zz" . "$B$6$s(B")  ("bx" . "$B$S$g$&(B")  ("bx" . "$B$S$g$&(B")  
    ("dx" . "$B$B$g$&(B")  ("gx" . "$B$.$g$&(B")  ("hx" . "$B$R$g$&(B")  ("kx" . "$B$-$g$&(B")  ("mx" . "$B$_$g$&(B")  
    ("nx" . "$B$K$g$&(B")  ("px" . "$B$T$g$&(B")  ("rx" . "$B$j$g$&(B")  ("sx" . "$B$7$g$&(B")  ("bv" . "$B$S$e$&(B")  
    ("dv" . "$B$B$e$&(B")  ("fv" . "$B$U$e!<(B")  ("gv" . "$B$.$e$&(B")  ("hv" . "$B$R$e$&(B")  ("kv" . "$B$-$e$&(B")  
    ("mv" . "$B$_$e$&(B")  ("nv" . "$B$K$e$&(B")  ("pv" . "$B$T$e$&(B")  ("rv" . "$B$j$e$&(B")  ("sv" . "$B$7$e$&(B")  
    ("vv" . "$B$&!+$e!<(B")      
    ))

; (defvar anthy-azik-mode-katakana-map
;   '(
;     (";" . "$B%C(B")  ("x;" . ";")  ("b." . "$B%V(B")  ("bd" . "$B%Y%s(B")  ("bh" . "$B%V%&(B")  
;     ("bj" . "$B%V%s(B")  ("bk" . "$B%S%s(B")  ("bl" . "$B%%(Bs")  ("bn" . "$B%P%s(B")  ("bp" . "$B%%(B&")  
;     ("bq" . "$B%P%$(B")  ("br" . "$B%P%i(B")  ("bt" . "$B%S%H(B")  ("bw" . "$B%Y%$(B")  ("bx" . "$B%Y%$(B")  
;     ("byd" . "$B%S%'%s(B")  ("byh" . "$B%S%e%&(B")  ("byj" . "$B%S%e%s(B")  ("byl" . "$B%S%g%s(B")  ("byn" . "$B%S%c%s(B")  
;     ("byp" . "$B%S%g%&(B")  ("byq" . "$B%S%c%$(B")  ("byw" . "$B%S%'%$(B")  ("byz" . "$B%S%c%s(B")  ("bz" . "$B%P%s(B")  
;     ("ca" . "$B%A%c(B")  ("cc" . "$B%A%c(B")  ("cd" . "$B%A%'%s(B")  ("ce" . "$B%A%'(B")  ("cf" . "$B%A%'(B")  
;     ("ch" . "$B%A%e%&(B")  ("ci" . "$B%A(B")  ("cj" . "$B%A%e%s(B")  ("ck" . "$B%A%s(B")  ("cl" . "$B%A%g%s(B")  
;     ("cn" . "$B%A%c%s(B")  ("co" . "$B%A%g(B")  ("cp" . "$B%A%g%&(B")  ("cq" . "$B%A%c%$(B")  ("cu" . "$B%A%e(B")  
;     ("cv" . "$B%A%c%$(B")  ("cw" . "$B%A%'%$(B")  ("cx" . "$B%A%'%$(B")  ("cz" . "$B%A%c%s(B")  ("dch" . "$B%G%e!<(B")  
;     ("dci" . "$B%G%#(B")  ("dck" . "$B%G%#%s(B")  ("dcp" . "$B%I%%!<(B")  ("dcu" . "$B%G%e(B")  ("dd" . "$B%G%s(B")  
;     ("df" . "$B%G(B")  ("dg" . "$B%@%,(B")  ("dh" . "$B%E%&(B")  ("dj" . "$B%E%s(B")  ("dk" . "$B%B%s(B")  
;     ("dl" . "$B%I%s(B")  ("dm" . "$B%G%b(B")  ("dn" . "$B%@%s(B")  ("dp" . "$B%I%&(B")  ("dq" . "$B%@%$(B")  
;     ("dr" . "$B%G%"%k(B")  ("ds" . "$B%G%9(B")  ("dt" . "$B%@%A(B")  ("dv" . "$B%G%s(B")  ("dw" . "$B%G%$(B")  
;     ("dy" . "$B%G%#(B")  ("dz" . "$B%@%s(B")  ("fd" . "$B%U%'%s(B")  ("fh" . "$B%U%&(B")  ("fj" . "$B%U%s(B")  
;     ("fk" . "$B%U%#%s(B")  ("fl" . "$B%U%)%s(B")  ("fm" . "$B%U%`(B")  ("fn" . "$B%U%!%s(B")  ("fp" . "$B%U%)!<(B")  
;     ("fq" . "$B%U%!%$(B")  ("fr" . "$B%U%k(B")  ("fs" . "$B%U%!%$(B")  ("fw" . "$B%U%'%$(B")  ("fz" . "$B%U%!%s(B")  
;     ("gd" . "$B%2%s(B")  ("gh" . "$B%0%&(B")  ("gj" . "$B%0%s(B")  ("gk" . "$B%.%s(B")  ("gl" . "$B%4%s(B")  
;     ("gn" . "$B%,%s(B")  ("gp" . "$B%4%&(B")  ("gq" . "$B%,%$(B")  ("gr" . "$B%,%i(B")  ("gt" . "$B%4%H(B")  
;     ("gw" . "$B%2%$(B")  ("gyd" . "$B%.%'%s(B")  ("gyh" . "$B%.%e%&(B")  ("gyj" . "$B%.%e%s(B")  ("gyl" . "$B%.%g%s(B")  
;     ("gyn" . "$B%.%c%s(B")  ("gyp" . "$B%.%g%&(B")  ("gyq" . "$B%.%c%$(B")  ("gyw" . "$B%.%'%$(B")  ("gyz" . "$B%.%c%s(B")  
;     ("gz" . "$B%,%s(B")  ("hd" . "$B%X%s(B")  ("hf" . "$B%U(B")  ("hga" . "$B%R%c(B")  ("hgd" . "$B%R%'%s(B")  
;     ("hge" . "$B%R%'(B")  ("hgh" . "$B%R%e%&(B")  ("hgj" . "$B%R%e%s(B")  ("hgl" . "$B%R%g%s(B")  ("hgn" . "$B%R%c%s(B")  
;     ("hgo" . "$B%R%g(B")  ("hgp" . "$B%R%g%&(B")  ("hgq" . "$B%R%c%$(B")  ("hgu" . "$B%R%e(B")  ("hgw" . "$B%R%'%$(B")  
;     ("hgz" . "$B%R%c%s(B")  ("hh" . "$B%U%&(B")  ("hj" . "$B%U%s(B")  ("hk" . "$B%R%s(B")  ("hl" . "$B%[%s(B")  
;     ("hn" . "$B%O%s(B")  ("hp" . "$B%[%&(B")  ("hq" . "$B%O%$(B")  ("ht" . "$B%R%H(B")  ("hw" . "$B%X%$(B")  
;     ("hyd" . "$B%R%'%s(B")  ("hyh" . "$B%R%e%&(B")  ("hyl" . "$B%R%g%s(B")  ("hyp" . "$B%R%g%&(B")  ("hyq" . "$B%R%c%$(B")  
;     ("hyw" . "$B%R%'%$(B")  ("hyz" . "$B%R%c%s(B")  ("hz" . "$B%O%s(B")  ("jd" . "$B%8%'%s(B")  ("jf" . "$B%8%e(B")  
;     ("jh" . "$B%8%e%&(B")  ("jj" . "$B%8%e%s(B")  ("jk" . "$B%8%s(B")  ("jl" . "$B%8%g%s(B")  ("jn" . "$B%8%c%s(B")  
;     ("jp" . "$B%8%g%&(B")  ("jq" . "$B%8%c%$(B")  ("jv" . "$B%8%e%&(B")  ("jw" . "$B%8%'%$(B")  ("jz" . "$B%8%c%s(B")  
;     ("kA" . "$B%u(B")  ("kE" . "$B%v(B")  ("kd" . "$B%1%s(B")  ("kf" . "$B%-(B")  ("kga" . "$B%-%c(B")  
;     ("kgd" . "$B%-%'%s(B")  ("kge" . "$B%-%'(B")  ("kgh" . "$B%-%e%&(B")  ("kgl" . "$B%-%g%s(B")  ("kgn" . "$B%-%c%s(B")  
;     ("kgo" . "$B%-%g(B")  ("kgp" . "$B%-%g%&(B")  ("kgq" . "$B%-%c%$(B")  ("kgu" . "$B%-%e(B")  ("kgw" . "$B%-%'%$(B")  
;     ("kgz" . "$B%-%c%s(B")  ("kh" . "$B%/%&(B")  ("kj" . "$B%/%s(B")  ("kk" . "$B%-%s(B")  ("kl" . "$B%3%s(B")  
;     ("km" . "$B%-(B")  ("kn" . "$B%+%s(B")  ("kp" . "$B%3%&(B")  ("kq" . "$B%+%$(B")  ("kr" . "$B%+%i(B")  
;     ("kt" . "$B%3%H(B")  ("kv" . "$B%-%s(B")  ("kw" . "$B%1%$(B")  ("kyd" . "$B%-%'%s(B")  ("kyh" . "$B%-%e%&(B")  
;     ("kyj" . "$B%-%e%s(B")  ("kyl" . "$B%-%g%s(B")  ("kyn" . "$B%-%c%s(B")  ("kyp" . "$B%-%g%&(B")  ("kyq" . "$B%-%c%$(B")  
;     ("kyw" . "$B%-%'%$(B")  ("kyz" . "$B%-%c%s(B")  ("kz" . "$B%+%s(B")  ("m." . "$B%`(B")  ("md" . "$B%a%s(B")  
;     ("mf" . "$B%`(B")  ("mga" . "$B%_%c(B")  ("mgd" . "$B%_%'%s(B")  ("mge" . "$B%_%'(B")  ("mgh" . "$B%_%e%&(B")  
;     ("mgj" . "$B%_%e%s(B")  ("mgl" . "$B%_%g%s(B")  ("mgn" . "$B%_%c%s(B")  ("mgo" . "$B%_%g(B")  ("mgp" . "$B%_%g%&(B")  
;     ("mgq" . "$B%_%c%$(B")  ("mgu" . "$B%_%e(B")  ("mgw" . "$B%_%'%$(B")  ("mgz" . "$B%_%c%s(B")  ("mh" . "$B%`%&(B")  
;     ("mj" . "$B%`%s(B")  ("mk" . "$B%_%s(B")  ("ml" . "$B%b%s(B")  ("mn" . "$B%b%N(B")  ("mp" . "$B%b%&(B")  
;     ("mq" . "$B%^%$(B")  ("mr" . "$B%^%k(B")  ("ms" . "$B%^%9(B")  ("mt" . "$B%^%?(B")  ("mv" . "$B%`%s(B")  
;     ("mw" . "$B%a%$(B")  ("myd" . "$B%_%'%s(B")  ("myh" . "$B%_%e%&(B")  ("myj" . "$B%_%e%s(B")  ("myl" . "$B%_%g%s(B")  
;     ("myn" . "$B%_%c%s(B")  ("myp" . "$B%_%g%&(B")  ("myq" . "$B%_%c%$(B")  ("myw" . "$B%_%'%$(B")  ("myz" . "$B%_%c%s(B")  
;     ("mz" . "$B%^%s(B")  ("n." . "$B%L(B")  ("nb" . "$B%M%P(B")  ("nd" . "$B%M%s(B")  ("nf" . "$B%L(B")  
;     ("nga" . "$B%K%c(B")  ("ngd" . "$B%K%'%s(B")  ("nge" . "$B%K%'(B")  ("ngh" . "$B%K%e%&(B")  ("ngj" . "$B%K%e%s(B")  
;     ("ngl" . "$B%K%g%s(B")  ("ngn" . "$B%K%c%s(B")  ("ngo" . "$B%K%g(B")  ("ngp" . "$B%K%g%&(B")  ("ngq" . "$B%K%c%$(B")  
;     ("ngu" . "$B%K%e(B")  ("ngw" . "$B%K%'%$(B")  ("ngz" . "$B%K%c%s(B")  ("nh" . "$B%L%&(B")  ("nj" . "$B%L%s(B")  
;     ("nk" . "$B%K%s(B")  ("nl" . "$B%N%s(B")  ("np" . "$B%N%&(B")  ("nq" . "$B%J%$(B")  ("nr" . "$B%J%k(B")  
;     ("nt" . "$B%K%A(B")  ("nv" . "$B%L%s(B")  ("nw" . "$B%M%$(B")  ("nyd" . "$B%K%'%s(B")  ("nyh" . "$B%K%e%&(B")  
;     ("nyj" . "$B%K%e%s(B")  ("nyl" . "$B%K%g%s(B")  ("nyn" . "$B%K%c%s(B")  ("nyp" . "$B%K%g%&(B")  ("nyq" . "$B%K%c%$(B")  
;     ("nyw" . "$B%K%'%$(B")  ("nyz" . "$B%K%c%s(B")  ("nz" . "$B%J%s(B")  ("pd" . "$B%Z%s(B")  ("pf" . "$B%]%s(B")  
;     ("pga" . "$B%T%c(B")  ("pgd" . "$B%T%'%s(B")  ("pge" . "$B%T%'(B")  ("pgh" . "$B%T%e%&(B")  ("pgj" . "$B%T%e%s(B")  
;     ("pgl" . "$B%T%g%s(B")  ("pgn" . "$B%T%c%s(B")  ("pgo" . "$B%T%g(B")  ("pgp" . "$B%T%g%&(B")  ("pgq" . "$B%T%c%$(B")  
;     ("pgu" . "$B%T%e(B")  ("pgw" . "$B%T%'%$(B")  ("pgz" . "$B%T%c%s(B")  ("ph" . "$B%W%&(B")  ("pj" . "$B%W%s(B")  
;     ("pk" . "$B%T%s(B")  ("pl" . "$B%]%s(B")  ("pn" . "$B%Q%s(B")  ("pp" . "$B%]%&(B")  ("pq" . "$B%Q%$(B")  
;     ("pv" . "$B%]%&(B")  ("pw" . "$B%Z%$(B")  ("pyd" . "$B%T%'%s(B")  ("pyh" . "$B%T%e%&(B")  ("pyj" . "$B%T%e%s(B")  
;     ("pyl" . "$B%T%g%s(B")  ("pyn" . "$B%T%c%s(B")  ("pyp" . "$B%T%g%&(B")  ("pyq" . "$B%T%c%$(B")  ("pyw" . "$B%T%'%$(B")  
;     ("pyz" . "$B%T%c%s(B")  ("pz" . "$B%Q%s(B")  ("q" . "$B%s(B")  ("rd" . "$B%l%s(B")  ("rh" . "$B%k%&(B")  
;     ("rj" . "$B%k%s(B")  ("rk" . "$B%j%s(B")  ("rl" . "$B%m%s(B")  ("rn" . "$B%i%s(B")  ("rp" . "$B%m%&(B")  
;     ("rq" . "$B%i%$(B")  ("rr" . "$B%i%l(B")  ("rw" . "$B%l%$(B")  ("ryd" . "$B%j%'%s(B")  ("ryh" . "$B%j%e%&(B")  
;     ("ryj" . "$B%j%e%s(B")  ("ryk" . "$B%j%g%/(B")  ("ryl" . "$B%j%g%s(B")  ("ryn" . "$B%j%c%s(B")  ("ryp" . "$B%j%g%&(B")  
;     ("ryq" . "$B%j%c%$(B")  ("ryw" . "$B%j%'%$(B")  ("ryz" . "$B%j%c%s(B")  ("rz" . "$B%i%s(B")  ("sd" . "$B%;%s(B")  
;     ("sf" . "$B%5%$(B")  ("sh" . "$B%9%&(B")  ("sj" . "$B%9%s(B")  ("sk" . "$B%7%s(B")  ("sl" . "$B%=%s(B")  
;     ("sm" . "$B%7%b(B")  ("sn" . "$B%5%s(B")  ("sp" . "$B%=%&(B")  ("sq" . "$B%5%$(B")  ("sr" . "$B%9%k(B")  
;     ("ss" . "$B%;%$(B")  ("st" . "$B%7%?(B")  ("sv" . "$B%5%$(B")  ("sw" . "$B%;%$(B")  ("syd" . "$B%7%'%s(B")  
;     ("syh" . "$B%7%e%&(B")  ("syj" . "$B%7%e%s(B")  ("syl" . "$B%7%g%s(B")  ("syp" . "$B%7%g%&(B")  ("syq" . "$B%7%c%$(B")  
;     ("syw" . "$B%7%'%$(B")  ("syz" . "$B%7%c%s(B")  ("sz" . "$B%5%s(B")  ("tU" . "$B%C(B")  ("tb" . "$B%?%S(B")  
;     ("td" . "$B%F%s(B")  ("tgh" . "$B%F%e!<(B")  ("tgi" . "$B%F%#(B")  ("tgk" . "$B%F%#%s(B")  ("tgp" . "$B%H%%!<(B")  
;     ("tgu" . "$B%F%e(B")  ("th" . "$B%D%&(B")  ("tj" . "$B%D%s(B")  ("tk" . "$B%A%s(B")  ("tl" . "$B%H%s(B")  
;     ("tm" . "$B%?%a(B")  ("tn" . "$B%?%s(B")  ("tp" . "$B%H%&(B")  ("tq" . "$B%?%$(B")  ("tr" . "$B%?%i(B")  
;     ("tsU" . "$B%C(B")  ("tsa" . "$B%D%!(B")  ("tse" . "$B%D%'(B")  ("tsi" . "$B%D%#(B")  ("tso" . "$B%D%)(B")  
;     ("tt" . "$B%?%A(B")  ("tw" . "$B%F%$(B")  ("tyd" . "$B%A%'%s(B")  ("tyh" . "$B%A%e%&(B")  ("tyj" . "$B%A%e%s(B")  
;     ("tyl" . "$B%A%g%s(B")  ("tyn" . "$B%A%c%s(B")  ("typ" . "$B%A%g%&(B")  ("tyq" . "$B%A%c%$(B")  ("tyw" . "$B%A%'%$(B")  
;     ("tyz" . "$B%A%c%s(B")  ("tz" . "$B%?%s(B")  ("vd" . "$B%t%'%s(B")  ("vk" . "$B%t%#%s(B")  ("vl" . "$B%t%)%s(B")  
;     ("vn" . "$B%t%!%s(B")  ("vp" . "$B%t%)!<(B")  ("vq" . "$B%t%!%$(B")  ("vw" . "$B%t%'%$(B")  ("vya" . "$B%t%c(B")  
;     ("vye" . "$B%t%'(B")  ("vyo" . "$B%t%g(B")  ("vyu" . "$B%t%e(B")  ("vz" . "$B%t%!%s(B")  ("wA" . "$B%n(B")  
;     ("wd" . "$B%&%'%s(B")  ("wf" . "$B%o(B")  ("wha" . "$B%&%!(B")  ("whe" . "$B%&%'(B")  ("whi" . "$B%&%#(B")  
;     ("who" . "$B%&%)(B")  ("whu" . "$B%&(B")  ("wk" . "$B%&%#%s(B")  ("wl" . "$B%&%)%s(B")  ("wn" . "$B%o%s(B")  
;     ("wp" . "$B%&%)!<(B")  ("wq" . "$B%o%$(B")  ("wr" . "$B%o%l(B")  ("wso" . "$B%&%)(B")  ("wt" . "$B%o%?(B")  
;     ("wz" . "$B%o%s(B")  ("xa" . "$B%7%c(B")  ("xc" . "$B%7%c(B")  ("xd" . "$B%7%'%s(B")  ("xe" . "$B%7%'(B")  
;     ("xf" . "$B%7%'%$(B")  ("xh" . "$B%7%e%&(B")  ("xi" . "$B%7(B")  ("xj" . "$B%7%e%s(B")  ("xk" . "$B%7%s(B")  
;     ("xl" . "$B%7%g%s(B")  ("xn" . "$B%7%c%s(B")  ("xo" . "$B%7%g(B")  ("xp" . "$B%7%g%&(B")  ("xq" . "$B%7%c%$(B")  
;     ("xt" . "$B%7%e%D(B")  ("xu" . "$B%7%e(B")  ("xv" . "$B%7%c%$(B")  ("xw" . "$B%7%'%$(B")  ("xxa" . "$B%!(B")  
;     ("xxe" . "$B%'(B")  ("xxi" . "$B%#(B")  ("xxo" . "$B%)(B")  ("xxu" . "$B%%(B")  ("xxh" . "$B"+(B")  
;     ("xxj" . "$B"-(B")  ("xxk" . "$B",(B")  ("xxl" . "$B"*(B")  ("xz" . "$B%7%c%s(B")  ("y<" . "$B"+(B")  
;     ("y>" . "$B"*(B")  ("y^" . "$B",(B")  ("yf" . "$B%f(B")  ("yh" . "$B%f%&(B")  ("yi" . "$B%p(B")  
;     ("yj" . "$B%f%s(B")  ("yl" . "$B%h%s(B")  ("yn" . "$B%d%s(B")  ("yp" . "$B%h%&(B")  ("yq" . "$B%d%$(B")  
;     ("yr" . "$B%h%k(B")  ("yv" . "$B%f%&(B")  ("yz" . "$B%d%s(B")  ("z." . "$B%:(B")  ("zc" . "$B%6(B")  
;     ("zd" . "$B%<%s(B")  ("zf" . "$B%<(B")  ("zh" . "$B%:%&(B")  ("zj" . "$B%:%s(B")  ("zk" . "$B%8%s(B")  
;     ("zl" . "$B%>%s(B")  ("zn" . "$B%6%s(B")  ("zp" . "$B%>%&(B")  ("zq" . "$B%6%$(B")  ("zr" . "$B%6%k(B")  
;     ("zv" . "$B%6%$(B")  ("zw" . "$B%<%$(B")  ("zx" . "$B%<%$(B")  ("zyd" . "$B%8%'%s(B")  ("zyh" . "$B%8%e%&(B")  
;     ("zyj" . "$B%8%e%s(B")  ("zyl" . "$B%8%g%s(B")  ("zyn" . "$B%8%c%s(B")  ("zyp" . "$B%8%g%&(B")  ("zyq" . "$B%8%c%$(B")  
;     ("zyw" . "$B%8%'%$(B")  ("zyz" . "$B%8%c%s(B")  ("zz" . "$B%6%s(B")  ("bx" . "$B%S%g%&(B")  ("bx" . "$B%S%g%&(B")  
;     ("dx" . "$B%B%g%&(B")  ("gx" . "$B%.%g%&(B")  ("hx" . "$B%R%g%&(B")  ("kx" . "$B%-%g%&(B")  ("mx" . "$B%_%g%&(B")  
;     ("nx" . "$B%K%g%&(B")  ("px" . "$B%T%g%&(B")  ("rx" . "$B%j%g%&(B")  ("sx" . "$B%7%g%&(B")  ("bv" . "$B%S%e%&(B")  
;     ("dv" . "$B%B%e%&(B")  ("fv" . "$B%U%e!<(B")  ("gv" . "$B%.%e%&(B")  ("hv" . "$B%R%e%&(B")  ("kv" . "$B%-%e%&(B")  
;     ("mv" . "$B%_%e%&(B")  ("nv" . "$B%K%e%&(B")  ("pv" . "$B%T%e%&(B")  ("rv" . "$B%j%e%&(B")  ("sv" . "$B%7%e%&(B")  
;     ("vv" . "$B%&!+%e!<(B")  
;     ))

(defun anthy-azik-mode ()
  (setq anthy-rkmap-keybind
	'(
	  ;; \C-p
	  (("hiragana" . 16) . "katakana")
	  (("katakana" . 16) . "hiragana")))
  (define-key anthy-mode-map (char-to-string 16) 'anthy-insert)
  (anthy-send-change-toggle-command "!")
  (mapcar (lambda (x)
	    (anthy-change-hiragana-map (car x) (cdr x)))
	  anthy-azik-mode-hiragana-map)
;  (mapcar (lambda (x)
;	    (anthy-change-katakana-map (car x) (cdr x)))
;	  anthy-azik-mode-katakana-map)
  )
