/* ʸᶭθФ˻Ȥǡ */
#ifndef _wordborder_h_included_
#define _wordborder_h_included_


#include <dic.h>
#include <alloc.h>
#include <segclass.h>

struct splitter_context;

/*
 * meta_wordλѲǽåΤ
 */
enum mw_check {
  /* ʤˤ⤻ */
  MW_CHECK_NONE,
  /* mw->wl̵wlȤ */
  MW_CHECK_SINGLE,
  MW_CHECK_BORDER,
  MW_CHECK_WRAP,
  MW_CHECK_PAIR,
  MW_CHECK_OCHAIRE,
  MW_CHECK_NUMBER,
  MW_CHECK_COMPOUND
};

/*
 * ʸΤɽ
 * Ϥޤmeta_word, word_listΥåȤ
 */
struct char_node {
  int max_len;
  struct meta_word *mw;
  struct word_list *wl;
};

/*
 * ƥμΩʤɤξ󡢺ǽѴܥ򲡤Ȥ
 * ۤ
 */
struct word_split_info_cache {
  struct char_node *cnode;

  /* å幽˻Ȥ */
  /* õΤ˻Ȥ */
  int *seq_len;/* ϤޤĹñĹ */
  /* ƬõΤ˻Ȥ */
  int *rev_seq_len;/* ǽĹñĹ */
  /* ʸᶭcontextΥԡ */
  int *seg_border;
  /* hmmǰӤɤä饹 */
  enum seg_class* best_seg_class;
  /*  */
  struct meta_word **best_mw;
  /*  */
  allocator MwAllocator, WlAllocator;
};

/*
 * meta_wordξ
 */
enum mw_status {
  MW_STATUS_NONE,
  /* mw->mw1ȤäƤ */
  MW_STATUS_WRAPPED,
  /* mw-mw1mw->mw2Ϣ */
  MW_STATUS_COMBINED,
  /* ʣ */
  MW_STATUS_COMPOUND,
  /* ʣθġʸ礷ưĤʸȤƸ */
  MW_STATUS_COMPOUND_PART,
  /* OCHAIREؽФ */
  MW_STATUS_OCHAIRE
};



/* metawordμˤΰ㤤 (metaword.c) */
extern struct metaword_type_tab_ {
  enum metaword_type type;
  int score;
  enum mw_status si;
  enum mw_check check;
} anthy_metaword_type_tab[];

/*
 * 0: Ƭ
 * 1: Ω
 * 2: 
 */
#define NR_PARTS 4
#define PART_PREFIX 0
#define PART_CORE 1
#define PART_POSTFIX 2
#define PART_DEPWORD 3

struct part_info {
  /* partĹ */
  int from, len;
  /* ʻ */
  wtype_t wt;
  seq_ent_t seq;
  /*  */
  int freq;
  /* Ψ */
  int ratio;
  /* °쥯饹 */
  enum dep_class dc;
};

/*
 * word_list: ʸ
 * Ƭ졢Ω졢졢°ޤ
 */
struct word_list {
  /**/
  int from, len; /* ʸ */
  int weak_len;  /* 夤ܤĹ */
  int is_compound; /* ʣ줫ɤ */

  int score;/*  */
  enum seg_class seg_class;
  enum constraint_stat can_use; /* ȶ˸٤äƤʤ */

  /* 뤿ǤϤʤơ¿ʽ˻Ȥ */
  int head_pos; /* hmmѤʻ */
  int tail_ct; /* meta_wordηѤγѷ */

  /**/
  int last_part;
  struct part_info part[NR_PARTS];

  /* word_listäݤξ */
  int node_id; /* °쥰դθϤnodeid*/
  const char *core_wt_name; /* word_listѤ롼̾ */

  /* Ʊfromword_listΥꥹ */
  struct word_list *next;
};


/* splitter.c */
#define SPLITTER_DEBUG_NONE 0
/* wordlistɽ */
#define SPLITTER_DEBUG_WL 1
/* metawordɽ */
#define SPLITTER_DEBUG_MW 2
/* A*nodeɽ */
#define SPLITTER_DEBUG_AN 4
/* ΩΥޥåʻ */
#define SPLITTER_DEBUG_ID 8
/* ʸ */
#define SPLITTER_DEBUG_1 16
int anthy_splitter_debug_flags(void);


/* defined in wordseq.c */
/* Ωʹߤ³ν */
void anthy_scan_node(struct splitter_context *sc,
		     struct word_list *wl,
		     xstr *follow, int node);
int anthy_get_node_id_by_name(const char *name);
int anthy_init_depword_tab(void);
void anthy_release_depword_tab(void);


/* defined in wordlist.c */
void anthy_commit_word_list(struct splitter_context *, struct word_list *wl);
struct word_list *anthy_alloc_word_list(struct splitter_context *);
void anthy_print_word_list(struct splitter_context *, struct word_list *);
void anthy_make_word_list_all(struct splitter_context *);
int anthy_init_wordlist(void);
/* extent */
struct extent *anthy_find_extent(struct splitter_context *,
				 int from, int len, int force);

/* defined in metaword.c */
void anthy_commit_meta_word(struct splitter_context *, struct meta_word *mw);
void anthy_make_metaword_all(struct splitter_context *);
void anthy_print_metaword(struct splitter_context *, struct meta_word *);
struct meta_word *
anthy_do_list_metaword(struct splitter_context *sc,
		       enum metaword_type type,
		       struct meta_word *mw, struct meta_word *mw2,
		       int weak);
struct meta_word *
anthy_do_cons_metaword(struct splitter_context *sc,
		       enum metaword_type type,
		       struct meta_word *mw, struct meta_word *mw2,
		       int weak);
void anthy_mark_border_by_metaword(struct splitter_context* sc,
				   struct meta_word* mw);


/* defined in evalborder.c */
void anthy_eval_border(struct splitter_context *, int, int, int);

/* defined at hmm.c */
void anthy_hmm(struct splitter_context *sc, int from, int to);

/* defined at seg_class.c */
void anthy_set_seg_class(struct word_list* wl);

/* ʻ(anthy_init_splitterǽ) */
extern wtype_t anthy_wtype_noun;
extern wtype_t anthy_wtype_name_noun;
extern wtype_t anthy_wtype_num_noun;
extern wtype_t anthy_wtype_prefix;
extern wtype_t anthy_wtype_num_prefix;
extern wtype_t anthy_wtype_postfix;
extern wtype_t anthy_wtype_num_postfix;
extern wtype_t anthy_wtype_name_postfix;
extern wtype_t anthy_wtype_sv_postfix;
extern wtype_t anthy_wtype_a_tail_of_v_renyou;
extern wtype_t anthy_wtype_v_renyou;
extern wtype_t anthy_wtype_noun_tail;/* ֤ơפȤ */
extern wtype_t anthy_wtype_n1;
extern wtype_t anthy_wtype_n10;
extern wtype_t anthy_wtype_noun_and_postfix;


#endif
