// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef HTMLREPORT_H
#define HTMLREPORT_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif

#include "report.h"

/**generate html output
  *@author Tobias Erbsland
  */

class htmlReport : public Report
{

private:

	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	/** Flag if the -tr- Tag already set.
	  */
	bool boolTrOpen;

	/** Creates perhaps all automatic generated fields.
	  */
	void checkAutoField( void );
	/** Jumps to the next field, and create perhaps a newline.
	  */
	bool nextField( void );
	/** Check if a tr tag necessary to open the current line.
	  */
	void checkMissingTrTag( void );

public:
	htmlReport();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual void startNewReport( const std::string &title, const reportType_e reportType );

	virtual void printPageFooter( void );
	virtual void printHeader( void );
	virtual void printField( const std::string &field );
	virtual void printField( const long field );
	virtual void printField( const double field );
	virtual void skipField( const bool realline = true );
	virtual void printFooter( void );
	virtual void printPageHeader( void );

	virtual ~htmlReport() {};
};

#endif
