dnl
dnl GNOME_CHECK_PKGCONFIG (script-if-enabled, [failflag])
dnl
AC_DEFUN([GNOME_CHECK_PKGCONFIG],[
	AC_PATH_PROG(PKG_CONFIG, pkg-config)
	have_pkgconfig=no
	if test -x "$PKG_CONFIG" ; then
	    have_pkgconfig=yes
	else
	    PKG_CONFIG=
	fi
	AC_MSG_CHECKING(for pkg-config)
	pkgconfig_required_version=0.8.0
	if test x$have_pkgconfig = xyes ; then
	    $PKG_CONFIG --atleast-pkgconfig-version $pkgconfig_required_version
	    if test $? -ne 0; then
		echo "*** Your version of pkg-config is too old. You need version $pkgconfig_required_version or newer."
		echo "*** See http://www.freedesktop.org/software/pkgconfig"
		have_pkgconfig=no
	    fi
	fi
	if test x$have_pkgconfig = xyes ; then
	    AC_MSG_RESULT(yes)
	else
	    PKG_CONFIG=
	    AC_MSG_RESULT(not found)
 	    if test x$2 = xfail; then
		AC_MSG_ERROR([
*** You need the latest pkg-config (at least $pkgconfig_required_version).
*** Get the latest version of pkg-config from
*** http://www.freedesktop.org/software/pkgconfig.])
	    fi
	fi
	AC_SUBST(PKG_CONFIG)

	AC_PROVIDE([GNOME_REQUIRE_PKGCONFIG])
])

dnl
dnl GNOME_REQUIRE_PKGCONFIG
dnl
AC_DEFUN([GNOME_REQUIRE_PKGCONFIG],[
	GNOME_CHECK_PKGCONFIG([], fail)
])
