#  Alicq ICQ client: XOSD Notification Plugin For Alicq                         
#  Copyright Alexander V. Butenko (2004)
#  Userfriendly additions by Andrey M. Izrantsev 
#  Changelog: 
#    10 Aug 2004 - X Resource Database support
#                  More XOSD features support
#    25 Jul 2004 - Userfriendly additions begin their life :)

# Default parameters set via xrdb
option add *xosdActive 1 widgetDefault
option add *xosdMessage {Incoming Messsage from $nick}  widgetDefault
option add *xosdColor   {#E5F3FF} widgetDefault
option add *xosdFont    {-*-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*} widgetDefault
option add *xosdShadow      0       widgetDefault
option add *xosdShadowColor #000000 widgetDefault
option add *xosdOutline      1       widgetDefault
option add *xosdOutlineColor #000000 widgetDefault
option add *xosdPosition bottom-left widgetDefault
option add *xosdIndent   30          widgetDefault
option add *xosdOffset   0           widgetDefault
option add *xosdDelay    3           widgetDefault


# Module metainformation
namespace eval meta {
    set name "XOSD"
    set description "XOSD Notification plugin"
    set author "Alexander V. Butenko <avb@avb.bas-net.by>\nAndrey M. Izrantsev <b_dancer@rambler.ru>"
	array set active { 
		  type boolean
		  menu {ICQ "XOSD Notificate"}
		  description "Activate notification"
		  save change
		  weight .0
	 }
	 set active(default) [option get . xosdActive XosdActive]

	 array set message {
		  weight .11
		  description "Format of the displayed message"
		  save change
	 }
	 set message(default) [option get . xosdMessage XosdMessage]

	 array set logmessage {
		  weight .12
		  description "Format of the log string"
		  default {$date alicq Incoming message from $nick}
		  save change
	 }

	 array set logfile {
		  weight .13
		  description "Log filename"
		  default "~/.alicq/incoming.log"
		  type file
		  save change
	 }

	 array set color {
		  description "Color"
		  weight .14
		  save change
	 }
	 set color(default) [option get . xosdColor XosdColor]

	 array set font {
		  description "Font"
		  weight .15
		  save change
	 }
	 set font(default) [option get . xosdFont XosdFont]

 	 array set shadow {
 		  description "Shadow size, px"
 		  weight .16
 		  save change
 	 }
	 set shadow(default) [option get . xosdShadow XosdShadow]

	 array set shadowcolor {
		  description "Shadow color"
		  weight .17
		  save change
	 }
	 set shadowcolor(default) [option get . xosdShadowColor XosdShadowColor]

	 array set outline {
		  description "Outline size, px"
		  weight .18
		  save change
	 }
	 set outline(default) [option get . xosdOutline XosdOutline]

	 array set outlinecolor {
		  description "Outline color"
		  weight .19
		  save change
	 }
	 set outlinecolor(default) [option get . xosdOutlineColor XosdOutlineColor]

	 array set position {
		  description "Position" 
		  type variant 
		  weight .20
		  values {bottom-left bottom-middle bottom-right
		  	center-left center-middle center-right top-left
			top-middle top-right}
		  save change
	 }
	 set position(default) [option get . xosdPosition XosdPosition]

	 array set xoffset {
		  description "X Offset, px" 
		  weight .22
		  save change
	 }
	 set xoffset(default) [option get . xosdIndent XosdIndent]

	 array set yoffset {
		  description "Y Offset, px" 
		  weight .23
		  save change
	 }
	 set yoffset(default) [option get . xosdOffset XosdOffset]

	 array set delay {
		  description "View Delay, sec" 
		  weight .24
		  save change
	 }
	 set delay(default) [option get . xosdDelay XosdDelay]
}

handler Incoming onprivmsg {type sender args} {
	 variable active
	 variable logfile
	 variable logmessage
	 variable message
	 variable color
	 variable font
	 variable position
	 variable shadow
	 variable shadowcolor
	 variable outline
	 variable outlinecolor
	 variable xoffset
	 variable yoffset
	 variable delay

	 foreach {pos align} [split $position -] break

	 if {![string is true $active]} return
	 set fmt {%X %x}
	 set date [clock format [clock seconds] -format $fmt]
	 set nick [get $sender Alias]

	 exec echo [subst $message] | osd_cat -A $align -p $pos -i $xoffset\
	 	-o $yoffset --color=$color --font=$font -d $delay\
		--shadow=$shadow --shadowcolour=$shadowcolor\
		--outline=$outline --outlinecolour=$outlinecolor &

	 if {[catch {
		  set fd [open $logfile a+]
		  puts $fd [subst $logmessage]
		  close $fd
    } reason]} { Event Log error "Can't write to $xosd_logfile"}
}

