# Message events (JEP-0022) support

namespace import ::xmpp::*
handler xmpp:/message acknowledge {obj path attr val} {
	# Handle acknowledgements
	array set opt $attr
	upvar 0 $obj context
	if {![info exists context(ACK)]} return
	# If acknowledge id is present, message is acknowledgement.
	# Otherwise this is message which should be possibly 
	# acknowledged by us.
	if {[info exists context(acknowledge-id)]} {
		Event $context(uid)|Acknowledgement $context(ACK)\
			$context(uid) $context(acknowledge-id)
	} elseif {[lsearch $context(ACK) client]!=-1} {
		# If message has no ID, assign emty ID for acknowledgement
		if {![info exists opt(id)]} { set opt(id) "" }
		[namespace tail $obj] send [tag message to $opt(from)\
		     [tag {jabber:x:event x} [tag id $opt(id)][tag delivered]]]
	}
}

# If id is specified in message, then message has delivery aknowledgement
handler xmpp:/message/jabber:x:event:x/id ACK {obj path attr val} {
	set ${obj}(acknowledge-id) $val
}

# Acknowledgement on delivery - message received by client
handler xmpp:/message/jabber:x:event:x/delivered delivered {obj path attr val} {
	lappend ${obj}(ACK) client
}

# Acknowledgement on delivery - message received by server as offline
handler xmpp:/message/jabber:x:event:x/offline offline {obj path attr val} {
	lappend ${obj}(ACK) server
}

# Add event request to outgoing messages
filter Send askEvent {type uid message} {
	if {$type=="raw"} {
		set ack [tag offline][tag delivered]
		append message [tag {jabber:x:event x} $ack]
	}
	list $type $uid $message
} 0.81

