//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_PHOTOPREVIEWWIDGET_H
#define GUI_PHOTOPREVIEWWIDGET_H

//--------------------
//forward declarations
class QPixmap;
class QString;
class Photo;
//--------------------

#define PHOTO_MARGIN 4
#define PHOTO_SHADOW 3
#define PHOTO_SHADOW_END_OFFSET 2
#define PHOTO_TEXT_MARGIN 1

#include <qiconview.h>

//=====================================
/*! \brief Displays photo thumbnail and description.
 */
//=====================================
class PhotoPreviewWidget : public QIconViewItem
{
public:
  ///Sets subalbum pointer
  PhotoPreviewWidget( QIconView *parent, Photo* phto );

  ///Returns photo pointer
  Photo* getPhoto();

  ///Update photo thumbnail from background object
  void updateImage();

  ///Update photo description
  void updateDescription();

  void paint( QPainter *p );

  ///Repain iconview item
  void paintItem( QPainter* p,
                  const QColorGroup& cg);

  void paintFocus( QPainter *p, const QColorGroup &cg );

  void setText ( const QString & text );

  void setPixmap(const QPixmap& p, bool redraw);
  
  bool acceptDrop( const QMimeSource *e) const;

  int compare ( QIconViewItem * i ) const;

  void setMousedOver(bool val);

  QRect getPhotoInfoRect();

  //returns the top left corner of the displayed image in screen coordinates
  QPoint getPhotoPos();
 //----------------------
private:
  void initializeItemRect();

  ///Pointer to photo backend object
  Photo* phto;

  int calibratedWidth;

bool mousedOver;

  QRect photoInfoRect;
  
  ///offsets used to center pixmap
  int pixmapXOffset, pixmapYOffset;
///----------------------
};
//======================

#endif //GUI_PHOTOPREVIEWWIDGET_H
