//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <fstream>
#include <qstring.h>
#include <qfile.h>
#include <qdir.h>
#include <qlibrary.h>
//#include <qglobal.h>

//Projectwide includes
#include "fileTools.h"

//==============================================
//PLATFORM_SPECIFIC_CODE

//Includes and defines for getWindowsFolderLocation
#ifdef Q_OS_WIN

#include <shlobj.h>

#ifndef CSIDL_APPDATA
#define CSIDL_APPDATA 0x001a
#endif

#ifndef CSIDL_LOCAL_APPDATA
#define CSIDL_LOCAL_APPDATA 0x001c
#endif

#endif //Q_OS_WIN
//==============================================
bool moveFile( QString oldName, QString newName)
{
  QDir rootDir;
  
  //attempt to rename file
  if(!rootDir.rename( oldName, newName))
  {
    //move failed, copy file and remove original
    
    //copy failed! sound alert and do not remove original!!!
    if(!copyFile(oldName, newName))
      return false;

    //copy succeded, remove original and return
    rootDir.remove(oldName);
  }
  
  //move succeeded either directly or via copying and removing original file
  return true;
}
//==============================================
bool copyFile(QString oldFilePath, QString newFilePath)
{
  //same file, no need to copy
  if(oldFilePath.compare(newFilePath) == 0)
    return true;

  //load both files
  QFile oldFile(oldFilePath);
  QFile newFile(newFilePath);
  bool openOld = oldFile.open( IO_ReadOnly );
  bool openNew = newFile.open( IO_WriteOnly );

  //if either file fails to open bail
  if(!openOld || !openNew) { return false; }

  //copy contents
  uint BUFFER_SIZE = 16000;
  char* buffer = new char[BUFFER_SIZE];
  while(!oldFile.atEnd())
  {
    Q_ULONG len = oldFile.readBlock( buffer, BUFFER_SIZE );
    newFile.writeBlock( buffer, len );
  }

  //deallocate buffer
  delete[] buffer;
  buffer = NULL;
  return true;
}
//==============================================
//PLATFORM_SPECIFIC_CODE
#ifdef Q_OS_WIN
bool getWindowsFolderLocation(FOLDER_TYPE type, QString& path)
{
  //get pointer to item identifier
  int folder;
  switch(type)
  {
    case APPLICATION_DATA:
      folder = CSIDL_APPDATA; break;
    case LOCAL_SETTINGS_APPLICATION_DATA:
      folder = CSIDL_LOCAL_APPDATA; break;
    //unhandeled folder type
    default:
      return false;
  }

  //call unicode or local-specific functions as necessary to get folder path
  bool success = true;
  QT_WA(
  {
    //unicode version
    unsigned short folderPath[MAX_PATH];
    if( SHGetSpecialFolderPathW(0, folderPath, folder, false) )
      path = QString::fromUcs2( (ushort*)folderPath );
    else
      success = false;
  },
  { 
    //non-unicode version
    char folderPath[MAX_PATH];
    if( SHGetSpecialFolderPathA( 0, folderPath, folder, false ) )
      path = QString::fromLocal8Bit( folderPath );
    else
      success = false;
  });

  //if failed to get LOCAL_SETTINGS_APPLICATION_DATA location then
  //try again using APPLICATION_DATA since this is likely Win95/Win98 (or ME?)
  if( (!success) && (type == LOCAL_SETTINGS_APPLICATION_DATA) )
    return getWindowsFolderLocation( APPLICATION_DATA, path );
  else 
    return success;
}
#endif //Q_OS_WIN
//==============================================
QString fixFilename( QString filename )
{ 
  filename.replace( QChar(' '), "_" );
  filename.replace( "<", "" );
  filename.replace( ">", "" );
  filename.replace( "&", "and" );
  filename.replace( "\"", "" );
  filename.replace( "\'", "" );
  filename.replace( "?", "" );
  return filename;
}
//==============================================