#include <Foundation/Foundation.h>
#include "CalendarDomain.h"
#include "CalendarEvent.h"
#include "CalendarUser.h"

@implementation CalendarGroup

+ (CalendarGroup *) calendarGroupWithName:(NSString *)name
									owner:(CalendarUser *)owner
{
	return AUTORELEASE([[self alloc] initWithName:name
											owner:owner]);
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"Group:%@ [%d event%@]",
		_name, [_eventList count], [_eventList count] > 1?@"s":@""];
}

- (id) initWithName:(NSString *)name
			  owner:(CalendarUser *)owner
{
	__owner = owner;

	ASSIGN(_name, name);

	_eventList = [NSMutableArray new];

	return self;
}

- (void) dealloc
{

	RELEASE(_eventList);

	RELEASE(_name);

	[super dealloc];
}

- (NSString *) name
{
	return (_name);
}

- (CalendarUser *) owner
{
	return (__owner);
}

- (CalendarDomain *) calendarDomain
{
	return [__owner calendarDomain];
}

- (void) setCalendarEvent:(CalendarEvent *)event
{
	if ([_eventList containsObject:event])
	{
		return;
	}


	{
		/* the domain will match foreign user in another domain */
		CalendarUser *user = [[self calendarDomain] calendarUser:[event owner]];
		event = [user setCalendarEvent:event];
	}

	[_eventList addObject:event];
	[event setCalendarGroup:self];
}

- (void) removeCalendarEvent:(CalendarEvent *)event
{
	[_eventList removeObject:event];
}

@end

@implementation CalendarGroupManager

- (id) initWithCalendarGroup:(CalendarGroup *)group
		manageByCalendarUser:(CalendarUser *)manager
{
	if (_group != nil)
	{
		return self;
	}

	ASSIGN(_group, group);
	ASSIGN(_manager, manager);

	return self;
}

- (NSString *) name
{
	if (_manager == [_group owner] || [_manager isRoot])
	{
		return [NSString stringWithString:[_group name]];
	}
	return nil;
}

- (CalendarUser *) owner
{
	if (_manager == [_group owner] || [_manager isRoot])
	{
		return AUTORELEASE([[CalendarUserManager alloc]
				initWithCalendarUser:[_group owner]
				manageByCalendarUser:_manager]);
	}
}

- (id <CalendarEvent>) setCalendarEvent:(id <CalendarEvent>)event
{
}
@end
