# Part of the A-A-P recipe executive: Testing of rule scopes

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string

def runaap(args):
    res = os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))
    if res:
        print "Aap exited with error value %d" % res
    return res

os.chdir("rectest")

# Create three recipes to test whether the rule scope is handled correctly.

rec1 = "rectest1.aap"
rec2 = "rectest2.aap"
rec3 = "rectest3.aap"
aapout = "rectest.aap.out"
touched = [ "foo.yin", "foo.zin", "foo.min", "foo.oin", "foo.ain", "foo.bin",
            "asdf.yin", "asdf.zin", "asdf.min", "aaa.cin" ]

def cleanup():
    for n in [ rec1, rec2, rec3, aapout ] + touched:
        try:
            os.remove(n)
        except:
            pass

cleanup()

f = open(rec1, "w")
f.write("""
:rule %%.aout : %%.ain
    :print atop
:rule {global} %%.bout : %%.bin
    :print btop
    :update asdf.yout
:rule {local} %%.cout : %%.cin
    :print ctop
:child %s
another:
        :update aaa.cout
""" % rec2)
f.close()

# child recipe.
f = open(rec2, "w")
f.write("""
:child %s
:rule %%.mout : %%.min
    :print mchild
:rule {global} %%.oout : %%.oin
    :print ochild
:rule {local} %%.pout : %%.pin
    :print pchild
""" % rec3)
f.close()

# grandchild recipe.
f = open(rec3, "w")
f.write("""
:rule %.xout : %.xin
    :print xgrandchild
:rule {global} %.yout : %.yin
    :print ygrandchild
    :update $(match).zout            # trigger local rule
:rule {local} %.zout : %.zin
    :print zgrandchild
    :update $(match).mout            # trigger rule in parent
""")
f.close()

# input files only need to exist, they contain "nothing"!
for n in touched:
    f = open(n, "w")
    f.write("nothing\n")
    f.close()


def check_contents(fname, expected):
    f = open(fname)
    actual = f.read()
    f.close()
    if actual != expected:
	print ('File contents wrong for "%s":\n%s\n--- instead of ---\n%s\n---'
						   % (fname, actual, expected))
        return 1
    return 0

# The first time running should result in two files being copied.
res = runaap("-f %s foo.yout foo.oout foo.aout foo.bout another > %s" % (rec1, aapout))

failed = res + check_contents(aapout,
"""ygrandchild
zgrandchild
mchild
ochild
atop
btop
ygrandchild
zgrandchild
mchild
ctop
""")

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
