#! /usr/bin/env python

LIBTOOLIZE = ("1.5", "--force")
ACLOCAL    = ("1.7",  "")
AUTOHEADER = ("2.54", "")
AUTOMAKE   = ("1.7",  "--add-missing --no-force --include-deps")
AUTOCONF   = ("2.54", "")

import os
import glob
import sys

def make_ver(ver):
  ver = ver.split(".")
  if not ver:
    return 0
  v = int(ver[0]) * 0x10000
  if len(ver) > 1:
    v += int(ver[1]) * 0x100
  if len(ver) > 2:
    v += int(ver[2])
  return v
  
def find_tool(tool, minver):
  print "Checking for %s %s or newer..." % (tool, minver),
  sys.stdout.flush()
  
  newest = ["", "", 0]
  binaries = []
  
  if os.environ.has_key(tool.upper()):
    binaries.append(os.environ[tool.upper()])
  else:
    for dir in os.environ["PATH"].split(":"):
      for fn in glob.glob(os.path.join(dir, tool + "*")):
        if os.access(fn, os.X_OK):
          binaries.append(fn)
  
  for fn in binaries:
    try:
      d = os.popen2(fn + " --version")[1].read()
      v = d.split("\n")[0].split(" ")[-1]
      ver = make_ver(v)
      if ver > newest[2]:
        newest[:] = [fn, v, ver]
    except Exception, e:
      print e
  
  if not newest[0]:
    print "not found"
    sys.exit(-1)
  elif newest[2] < make_ver(minver):
    print "found %s (version %s), too old" % (newest[0], newest[1])
    sys.exit(-1)
  print "%s (version %s)" % (newest[0], newest[1])
  return newest[0]

def run(cmd, args):
  print "running %s %s" % (cmd, args)
  if os.system(cmd + " " + args) != 0:
    sys.exit(-1)
      
if LIBTOOLIZE[0]:
  libtoolize = find_tool( "libtoolize", LIBTOOLIZE[0] )
if ACLOCAL[0]:
  aclocal    = find_tool( "aclocal",    ACLOCAL[0]    )
if AUTOMAKE[0]:
  automake   = find_tool( "automake",   AUTOMAKE[0]   )
if AUTOHEADER[0]:
  autoheader = find_tool( "autoheader", AUTOHEADER[0] )
if AUTOCONF[0]:
  autoconf   = find_tool( "autoconf",   AUTOCONF[0]   )

print

if LIBTOOLIZE[0]:
  run( libtoolize, LIBTOOLIZE[1] )
if ACLOCAL[0]:
  run( aclocal,    ACLOCAL[1]    )
if AUTOHEADER[0]:
  run( autoheader, AUTOHEADER[1] )
if AUTOMAKE[0]:
  run( automake,   AUTOMAKE[1]   )
if AUTOCONF[0]:
  run( autoconf,   AUTOCONF[1]   )
