/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "picture.h"

int loadpicture(struct picture *icon, const char *filename)
{
        FILE *in;
        int s;

        in = fopen(filename, "r");
        if(in == 0)
        {
                fprintf(stdout, "Can't open %s for read\n", filename);
                return -1;
        }
        if(fread(icon, sizeof(int), 4, in) < 4)
        {
                fprintf(stderr, "Short icon file: %s\n", filename);
                fclose(in);
                return -1;
        }

        s = icon->w*icon->h;
        if(s < 0 || s > 10000)
        {
                fprintf(stderr, "Messed up icon file[1]: %s\n", filename);
                fclose(in);
                return -1;
        }

        icon->data = g_new(unsigned char, 3*s);
        if(fread(icon->data, 3, s, in) != s)
        {
                fprintf(stderr, "Messed up icon file[2]: %s\n", filename);
                fclose(in);
		g_free(icon->data);
                return -1;
        }

        fclose(in);
        return 1;
}

int savepicture(struct picture *icon, const char *filename)
{
        FILE *out;
        int s;

        out = fopen(filename, "w");
        if(out == 0)
        {
                fprintf(stdout, "Can't open %s for write\n", filename);
                return -1;
        }
        if(fwrite(icon, sizeof(int), 4, out) < 4)
        {
                fprintf(stderr, "Write Error[1]!  file: %s\n", filename);
                fclose(out);
                return -1;
        }

        s = icon->w*icon->h;
        if(fwrite(icon->data, 3, s, out) != s)
        {
                fprintf(stderr, "Write Error[2]!  file: %s\n", filename);
                fclose(out);
                return -1;
        }

        fclose(out);
        return 1;
}

