/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __LOCATION_H__
#define __LOCATION_H__

#include <gtk/gtk.h>

/* emunify... */
#define CITY_SITES 0
#define OBS_SITES 1


#define EARTH_RADIUS (6371030.0) // meters

struct earthpos
{
	double latitude;
	double longitude;
	double elevation;	// Stored as distance from center of earth
};

struct location
{
        int type;       // 0 = city, 1 = observatory , 2 = other
        int cityid;
        int obsid;
        struct earthpos *otherpos;
};

struct site     // either city or observatory
{
        gchar *name;
        struct earthpos *pos;
};


struct earthpos *newearthpos(double latitiude, double longitude, 
	double elevation);
struct earthpos *copyearthpos(struct earthpos *oldpos);
void deleteearthpos(struct earthpos *pos);

struct location *newlocation();
struct location *copylocation(const struct location *oldloc);
void deletelocation(struct location *loc);

struct site *newsite(const char *name, double latitiude,
        double longitude, double elevation);
void deletesite(struct site *s);
GList **getsitelist(int sitelistnum);
struct site *getsite(gint sitelistnum, gint index);
gint getsitenum(gint sitelistnum, const gchar *name);
int addtositelist(int sitelistnum, struct site *s);

gchar *latitude2text(double latitude);
gchar *longitude2text(double longitude);
double text2latitude(const gchar *str_);
double text2longitude(const gchar *str_);
gchar *site2text(struct site *s);

void sitecombofill(GtkWidget *combo, int sitelistnum);

// getlocationup
// getearthposup

void initlocations();

#endif
