/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include "configurevista.h"

/* Protos */



struct vistaconfig *newvistaconfig(GladeXML *configxml)
{
	struct vistaconfig *vc;

	vc = g_new(struct vistaconfig, 1);

	vc->upspin = glade_xml_get_widget(configxml, "upspin");
	vc->upcombo = glade_xml_get_widget(configxml, "upcombo");
	vc->upentry = glade_xml_get_widget(configxml, "upentry");
	vc->flipbutton = glade_xml_get_widget(configxml, "flipbutton");
	vc->zoomspin = glade_xml_get_widget(configxml, "zoomspin");
	vc->centerraentry = glade_xml_get_widget(configxml, "centerraentry");
	vc->centerdecentry = glade_xml_get_widget(configxml, "centerdecentry");
	
	vc->oldview = 0;
	vc->curview = 0;

	vc->uplist = GTK_COMBO(vc->upcombo)->list;

	return vc;
}

void deletevistaconfig(struct vistaconfig *vc) 
{
	g_free(vc);
}

void vistaconfigupdate(struct vistaconfig *vc) 
{
	gchar *tmp;
	
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(vc->upspin), 
		vc->curview->uprotation);
	gtk_list_select_item(GTK_LIST(vc->uplist), vc->curview->uprefid);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(vc->flipbutton),
		vc->curview->fliplr);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(vc->zoomspin),
		vc->curview->zoom);

	tmp = g_double2text(vc->curview->ra_center*12.0/PI, ' ');
	gtk_entry_set_text(GTK_ENTRY(vc->centerraentry),
		tmp);
	g_free(tmp);
	
	tmp = g_double2text(vc->curview->dec_center*180.0/PI, ' ');
	gtk_entry_set_text(GTK_ENTRY(vc->centerdecentry),
		tmp);
	g_free(tmp);
}

void vistaconfigcollect(struct vistaconfig *vc)
{
	gchar *tmp;
	
	vc->curview->uprotation = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(vc->upspin));
	tmp = gtk_editable_get_chars(GTK_EDITABLE(vc->upentry), 0, -1);
	vc->curview->uprefid = getvistarefid(tmp);
	if(vc->curview->uprefid < 0) vc->curview->uprefid = 0;
	g_free(tmp);
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vc->flipbutton)))
		vc->curview->fliplr = 1;
	else vc->curview->fliplr = 0;
	vc->curview->zoom = gtk_spin_button_get_value_as_float(
		GTK_SPIN_BUTTON(vc->zoomspin));
	tmp = gtk_editable_get_chars(GTK_EDITABLE(vc->centerraentry), 0, -1);
	vc->curview->ra_center = text3double(tmp)*PI/12.0;
	g_free(tmp);
	tmp = gtk_editable_get_chars(GTK_EDITABLE(vc->centerdecentry), 0, -1);
	vc->curview->dec_center = text3double(tmp)*PI/180.0;
	g_free(tmp);
}

void vistaconfigsetup(struct configurator *cfg)
{
	static struct viewer *v = 0;

	v = cfg->v;
	if(cfg->viewinfo->oldview) deletevista(cfg->viewinfo->oldview);
	cfg->viewinfo->oldview = copyvista(v->view);

	if(cfg->viewinfo->curview) deletevista(cfg->viewinfo->curview);
	cfg->viewinfo->curview = copyvista(v->view);

	vistaconfigupdate(cfg->viewinfo);
}

void vistaconfigtry(struct configurator *cfg)
{
	vistaconfigcollect(cfg->viewinfo);
	vistaconfigupdate(cfg->viewinfo);
	viewersetvista(cfg->v, cfg->viewinfo->curview);
}

void vistaconfigrevert(struct configurator *cfg)
{
	if(cfg->viewinfo->curview) deletevista(cfg->viewinfo->curview);
	cfg->viewinfo->curview = copyvista(cfg->viewinfo->oldview);
	vistaconfigupdate(cfg->viewinfo);
	viewersetvista(cfg->v, cfg->viewinfo->curview);
}

void vistaconfigrefresh(struct configurator *cfg)
{
	cfg->viewinfo->curview->zoom = cfg->v->view->zoom;
	cfg->viewinfo->curview->ra_center = cfg->v->view->ra_center;
	cfg->viewinfo->curview->dec_center = cfg->v->view->dec_center;
	vistaconfigupdate(cfg->viewinfo);
}

/* ------------- Callbacks ------------ */
