\name{[.ggobi}
\alias{[.ggobi}
\alias{[[.ggobi}
\title{Obtains a reference to a ggobi dataset}
\description{
 This is a convenient syntax for referring to one or more
 datasets within a ggobi instance, either by index or by
 name.
 \code{[} operator returns a list of one or more objects of class
 \code{ggobiDataset},
 while \code{[[} is used to access a single dataset.
 These \code{ggobiDataset} objects can be used to refer to the dataset in the ggobi
 instance and the preferred type for the
 \code{.data} argument in most functions in the GGobi package.

 NOTE: This has changed in release 1.0.0 in order to be more
 consistent with list subsetting in R and it no longer returns
 the element if the index identifies only a single element.
}
\usage{
"[.ggobi"(x, ..., drop = FALSE)
"[[.ggobi"(x, ..., drop = FALSE)
}
\arguments{
  \item{x}{the object of class \code{ggobi}}
  \item{\dots}{the identifiers for the datasets within the ggobi instance.}
  \item{drop}{}
}
\value{
 One or more objects of class \code{ggobiDataset}.
 These are opaque references to internal C structures
 and should not be operated on directly. Instead, one
 should use the functions and methods that operate on objects
 of this class.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{names.ggobi}}
\code{\link{names.ggobiDataset}}
\code{\link{dim.ggobiDataset}}
\code{\link{dimnames.ggobiDataset}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g[[1]]

  names(g)
  g[["flea"]]

  dim(g[[1]])
  g$setData(system.file("data", "sat.xml", package="Rggobi"))
  g[[2]]
  g[["SAT scores"]]
}
\concept{visualization}
\concept{interactive graphics}
\keyword{classes}
