#include "configdialogR2impl.h"



/* 
 *  Constructs a configDialogR2Impl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
configDialogR2Impl::configDialogR2Impl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : configDialogR2( parent, name, TRUE, fl )
{
	conf.readConfig();

  	//KLocale::setMainCatalogue ("ksetisaver.mo");

	in_init=true;
	clientpathField->setText(conf.getSetipath());
	datapathField->setText(conf.getDatapath());	

	launchBox->setChecked(conf.isStartclient());
	//manualBox->setChecked(conf.isManualTransfer());

	if (conf.isStartclient()) {
		//manualBox->setEnabled(true);
		sameBox->setEnabled(true);
	 	if (conf.getDatapath() != conf.getSetipath()) {
			//cout << "Bing " << endl;
    	sameBox->setChecked(false);
   		clientpathField->setEnabled(true);
      clientpathButton->setEnabled(true);
		}
		else {
			sameBox->setChecked(true);
			clientpathField->setEnabled(false);
			clientpathButton->setEnabled(false);
		}
	}
	else {
		clientpathField->setEnabled(false);
		clientpathButton->setEnabled(false);
		sameBox->setEnabled(false);
	}



	if (conf.isParsekswconfig()) {
   	kswBox->setChecked(true);
	  launchBox->setEnabled(false);
		manualBox->setEnabled(false);
		manualBox->setChecked(false);
		launchBox->setChecked(false);
		clientpathField->setEnabled(false);
		setipathButton->setEnabled(false);
		sameBox->setEnabled(false);
	}
	
	soundBox->setChecked(conf.isPlayaudio());

	//ADVANCED
	QFont qtf;
	qtf=conf.getHeadF();
	headfontBox->setChecked(conf.isOverrideHead());
	headerfontButton->setEnabled(conf.isOverrideHead());
  headerfontLabel->setText(qtf.family());

	qtf=conf.getBigF();
	mediumfontBox->setChecked(conf.isOverrideBig());
	mediumfontButton->setEnabled(conf.isOverrideBig());
	mediumfontLabel->setText(qtf.family());

	qtf=conf.getSmallF();
	smallfontBox->setChecked(conf.isOverrideSmall());
	smallfontButton->setEnabled(conf.isOverrideSmall());
  smallfontLabel->setText(qtf.family());

	positioningBox->setChecked(conf.isManualPositioning());
	xSpinbox->setEnabled(conf.isManualPositioning());;
	xSpinbox->setValue(conf.getManX());
	ySpinbox->setEnabled(conf.isManualPositioning());
	ySpinbox->setValue(conf.getManY());

	//Manual transfer --not implemented---

	in_init=false;

}

/*
 *  Destroys the object and frees any allocated resources
 */
configDialogR2Impl::~configDialogR2Impl()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void configDialogR2Impl::choose_headerFont()
{
		QFont tempF;
		tempF = conf.getHeadF();
		int res = KFontDialog::getFont( tempF, false, this, true );
		if (res==KFontDialog::Accepted) {
     conf.setHeadF(tempF);
		 headerfontLabel->setText(tempF.family());	
		}
}
/*
 * public slot
 */
void configDialogR2Impl::choose_mediumFont()
{
		QFont tempF;
		tempF = conf.getBigF();
		int res = KFontDialog::getFont( tempF, false, this, true );
		if (res==KFontDialog::Accepted) {
     conf.setBigF(tempF);
		 mediumfontLabel->setText(tempF.family());	
		}
}
/*
 * public slot
 */
void configDialogR2Impl::choose_smallFont()
{
		QFont tempF;
		tempF = conf.getSmallF();
		int res = KFontDialog::getFont( tempF, false, this, true );
		if (res==KFontDialog::Accepted) {
     conf.setSmallF(tempF);
		 smallfontLabel->setText(tempF.family());	
		}
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_headerFont(int)
{
		headerfontButton->setEnabled(headfontBox->isChecked());
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_launch(int)
{
		if (launchBox->isChecked()) {
			kswBox->setChecked(false);
			enable_parseKsw(0);
			kswBox->setEnabled(false);
			clientpathField->setEnabled(true);
			clientpathButton->setEnabled(true);	
			sameBox->setEnabled(true);
			//manualBox->setEnabled(true);
		}
		else {
     	kswBox->setEnabled(true);
			clientpathField->setEnabled(false);
			clientpathButton->setEnabled(false);
			sameBox->setEnabled(false);
			//manualBox->setEnabled(false);
      manualBox->setChecked(false);
		}
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_mediumFont(int)
{
		mediumfontButton->setEnabled(mediumfontBox->isChecked());
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_parseKsw(int)
{
	if (in_init) { return; }
	if (kswBox->isChecked()) {
		KSetiwatchImporter kswi;
		kswi.readKswConfig();
		if (kswi.res != kswi.OK) {
			kswBox->setChecked(false);
      KMessageBox::sorry (this, "KSetiSaver was unable to find or parse the KSetiwatch config file.", "KSetiSaver problem", false);				
		}
		else {
			datapathField->setEnabled(false);
			//clientpathField->setEnabled(false);
			//clientpathButton->setEnabled(false);
			sameBox->setEnabled(false);
			setipathButton->setEnabled(false);
      KMessageBox::information (this, "KSetiSaver will now use the KSetiwatch configuration file.",\
           "KSetiSaver information", QString::null, false);
			launchBox->setChecked(false);
			launchBox->setEnabled(false);
			manualBox->setEnabled(false);
		}
	}
	else {
  	datapathField->setEnabled(true);
		setipathButton->setEnabled(true);
		launchBox->setEnabled(true);
  }
}

/*
 * public slot
 */
void configDialogR2Impl::enable_positioning(int)
{
		xSpinbox->setEnabled(positioningBox->isChecked());
		ySpinbox->setEnabled(positioningBox->isChecked());
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_smallFont(int)
{
		smallfontButton->setEnabled(smallfontBox->isChecked());
}
/* 
 * public slot
 */
void configDialogR2Impl::enable_sound(int)
{
	if (in_init) { return; }
	if(soundBox->isChecked()) {
		QString msg = "<H3>Attention!</H3> \
     I found this sound clips somewhere on the net. I'm not sure if it is allowed \
     to distribute this files.<BR> \
     They <I>may</I> be copyrighted by Paramount or someone else. \
     You use the audio files on your own risk<BR> \
     <B>Play audio?</B>";
		int res = KMessageBox::warningYesNo(this, msg, "KSetiSaver question");
		if (res != KMessageBox::Yes) {
  		soundBox->setChecked(false);
		}
	}
}
/* 
 * public slot
 */
void configDialogR2Impl::get_workunit()
{
    qWarning( "configDialogR2Impl::get_workunit() not yet implemented!" ); 
}


/*
 * public slot
 */
void configDialogR2Impl::sameBox_stateChanged( int ) {
	if (sameBox->isChecked()) {
  	clientpathField->setText(datapathField->text());
		clientpathField->setEnabled(false);
		clientpathButton->setEnabled(false);
	}
	else {
  	clientpathField->setEnabled(true);
		clientpathButton->setEnabled(true);
	}
}

void configDialogR2Impl::get_setipath()
{
	QString path=KFileDialog::getExistingDirectory (datapathField->text(), this, "Select seti@home directory");
	if (path != "" && path != QString::null) {
  	datapathField->setText(path);
		if (sameBox->isChecked()) {
    	clientpathField->setText(path);
		}
	}
}
/* 
 * public slot
 */
void configDialogR2Impl::ok_clicked()
{
  //General
	conf.setDatapath(datapathField->text());
	conf.setSetipath(clientpathField->text());
	conf.setParsekswconfig(kswBox->isChecked());
	conf.setPlayaudio(soundBox->isChecked());

	//Client options
	conf.setStartclient(launchBox->isChecked());
  conf.setManualTransfer(manualBox->isChecked());

	//Advanced
	conf.setOverrideHead(headfontBox->isChecked());
	conf.setOverrideBig(mediumfontBox->isChecked());
	conf.setOverrideSmall(smallfontBox->isChecked());
	conf.setManualPositioning(positioningBox->isChecked());
	conf.setManualCoors(xSpinbox->value(),ySpinbox->value());

	conf.saveConfig();
	accept();
}

