/*
 *  FreeGuide J2
 *
 *  Copyright (c) 2001-2004 by Andy Balaam and the FreeGuide contributors
 *
 *  freeguide-tv.sourceforge.net
 *
 *  Released under the GNU General Public License
 *  with ABSOLUTELY NO WARRANTY.
 *
 *  See the file COPYING for more information.
 */

package freeguide.gui.dialogs;

import freeguide.*;
import freeguide.lib.general.*;
import java.awt.*;
import javax.swing.*;

/**
 *  Tell the user there's a new version of FreeGuide available
 *
 *@author     Andy Balaam
 *@created    2nd December 2003
 *@version    1
 */
public class NewVersionDialog extends JDialog {

    /**
     * Constructor which sets the customiser up as a JDialog...
     *
     */
    public NewVersionDialog( JFrame parent ) {
        super( parent, "New Version Available", true);
        
        initComponents();
    }


    /**
     *  This method is called from within the constructor to initialize the
     *  form. WARNING: Do NOT modify this code. The content of this method is
     *  always regenerated by the Form Editor.
     */
    private void initComponents() {
        
        java.awt.GridBagConstraints gridBagConstraints;

		JLabel labTopMessage = new javax.swing.JLabel(
			"There is a new version of FreeGuide available at:" );
		
		butURL = new javax.swing.JButton( "http://freeguide-tv.sourceforge.net" );
		chkTellMeAgain = new javax.swing.JCheckBox( "Check this every time FreeGuide starts", true );
        butOK = new javax.swing.JButton( "OK" );
		
		Container pane = getContentPane();
		
        pane.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        pane.add(labTopMessage, gridBagConstraints);
		
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        pane.add(butURL, gridBagConstraints);
		butURL.addActionListener(
            new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    butURLActionPerformed(evt);
                }
            });
		
        gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        pane.add(chkTellMeAgain, gridBagConstraints);
		
		gridBagConstraints.gridy = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.NONE;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        pane.add(butOK, gridBagConstraints);

        butOK.addActionListener(
            new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    butOKActionPerformed(evt);
                }
            });

		getRootPane().setDefaultButton( butOK );
			
		pack();  // pack comes before the size instructions or they get ignored.
		
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();		
        setLocation((screenSize.width - getWidth()) / 2, (screenSize.height - getHeight()) / 2);
		
  }

    /**
     *  Description of the Method
     *
     *@param  evt  Description of the Parameter
     */
    private void butOKActionPerformed(java.awt.event.ActionEvent evt) {
		
		if( !chkTellMeAgain.isSelected() ) {
			
			FreeGuide.prefs.misc.put( "privacy", "no" );
			
		}

        quit();
    }
	
	/**
     *  Description of the Method
     *
     *@param  evt  Description of the Parameter
     */
    private void butURLActionPerformed(java.awt.event.ActionEvent evt) {
		
		String[] cmds = Utils.substitute(
			FreeGuide.prefs.commandline.getStrings( "browser_command" ),
			"%filename%",
			butURL.getText() );
            Utils.execNoWait(cmds);
		
    }
  
    /**
     *  Description of the Method
     *
     *@param  evt  Description of the Parameter
     */
    private void exitForm(java.awt.event.WindowEvent evt) {
        quit();
    }

    /**
     *  Closes the form and goes back to the viewer.
     */
    private void quit() {

        dispose();

    }


	private JButton butURL;
    private JCheckBox chkTellMeAgain;
    private JButton butOK;


}
