##############################################################################
#
# Copyright (c) 2003 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Global Adapter Service Tests

$Id: test_adapter.py 25177 2004-06-02 13:17:31Z jim $
"""
import unittest
from doctest import DocTestSuite

from zope.component.adapter import GlobalAdapterService

class GlobalAdapterServiceTests(unittest.TestCase):

    def test_pickling(self):
        from zope.component.tests.test_service import testServiceManager
        from zope.component.interfaces import IAdapterService
        testServiceManager.defineService('Adapters', IAdapterService)
        adapters = GlobalAdapterService()
        testServiceManager.provideService('Adapters', adapters)
        import pickle

        as = pickle.loads(pickle.dumps(adapters))
        self.assert_(as is adapters)

        testServiceManager._clear()

def test_suite():
    suite = unittest.makeSuite(GlobalAdapterServiceTests)
    suite.addTest(DocTestSuite('zope.component.adapter'))
    return suite
