/*
 * Written by Oron Peled <oron@actcom.co.il>
 * Copyright (C) 2004-2006, Xorcom
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef	XBUS_CORE_H
#define	XBUS_CORE_H

#include "xpd.h"

#define	MAX_BUSES		16

int xbus_core_init(void);		/* Initializer */
void xbus_core_shutdown(void);		/* Terminator */

/* Packet handling */
xpacket_t *xbus_packet_new(xbus_t *xbus, int flags);
void xbus_packet_free(xbus_t *xbus, xpacket_t *p);

/* packet queues */
void init_xbus_packet_queue(packet_queue_t *q, const char name[]);
void drain_xbus_packet_queue(xbus_t *xbus, packet_queue_t *q);
void xbus_enqueue_packet(xbus_t *xbus, packet_queue_t *q, xpacket_t *pack);
xpacket_t *xbus_dequeue_packet(packet_queue_t *q);

/* XBUS handling */
xbus_t	*xbus_of(int xbus_num);
xpd_t	*xpd_of(xbus_t *xbus, int xpd_num);
xbus_t	*xbus_new(xbus_ops_t *ops);
void xbus_remove(xbus_t *xbus);
void xbus_activate(xbus_t *xbus);
void xbus_disconnect(xbus_t *xbus);

void xbus_reset_counters(xbus_t *xbus);

int xbus_register_xpd(xbus_t *xbus, xpd_t *xpd);
int xbus_unregister_xpd(xbus_t *xbus, xpd_t *xpd);

#endif	/* XBUS_CORE_H */

