/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_compose2.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_abook_compose2(struct session *session)
{
    struct request *request = session->request;
    struct draft *draft = session->draft;
    struct options *options = session->options;
    struct role *role = NIL;
    char *s;

    if ((session->abook_compose_name == NIL) ||
        (session->abook_compose_email == NIL)) {
        session_message(session, "No compose name defined");
        session_log(session,
                    "[cmd_abook_compose2] called without compose name");
        session_redirect(session, request, "abook_list");
        return;
    }

    request_decode_form(request);
    if ((s = assoc_lookup(request->form, "role")))
        role = role_find(options->role_list, s);

    draft_role_set(draft, role);
    draft_init(draft);
    draft_init_rich_headers(draft);

    /* Set To address */
    draft->to
        = abook_text_to_string(draft->pool,
                               session->abook_compose_name,
                               session->abook_compose_email);

    free(session->abook_compose_name);
    session->abook_compose_name = NIL;

    free(session->abook_compose_email);
    session->abook_compose_email = NIL;

    session_redirect(session, request, "compose");
}
