/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ainfotext.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_AINFOTEXT_HXX
#define _SDR_ANIMATION_AINFOTEXT_HXX

#include <svx/sdr/animation/animationinfo.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class SdrObject;
class SdrTextObj;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoBlinkText : public AInfoMixer
		{
			// The animated object
			SdrObject&								mrObject;

		protected:
			// The blink frequency in ms
			sal_uInt32								mnFrequency;

			// The repeat count, init to 0L which means endless
			sal_uInt32								mnRepeat;

			// bitfield
			// Flag to decide if text will be shown when animation has ended
			unsigned								mbVisisbleWhenStopped : 1;
			unsigned								mbVisisbleWhenStarted : 1;

		private:
			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer* CreateBasicMixer();

		protected:
			// local initializations
			void ImplInit();

			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const;

		public:
			// basic constructor.
			AInfoBlinkText(SdrObject& rObject, sal_uInt32 nDefaultFrequency = 250L);

			// destructor
			virtual ~AInfoBlinkText();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;

			// React on changes of the object of this AnimationInfo.
			virtual void ActionChanged();

			// access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// Access to VisibleWhenSTarted flags
			sal_Bool IsVisibleWhenStarted() const;
			sal_Bool IsVisibleWhenStopped() const;

			// Decide if animation is allowed for the given VOC. Default always returns
			// sal_True. Maybe necessary to switch off for accessibility (e.g.)
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_AINFOTEXT_HXX

// eof
