/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: sdgrsitm.hxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDGRSITM_HXX
#define _SDGRSITM_HXX

#ifndef _SVDDEF_HXX
#include <bf_svx/svddef.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <bf_svtools/itemset.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX
#include <bf_svtools/poolitem.hxx>
#endif
namespace binfilter {

// ------------------
// - SdrGrafSetItem -
// ------------------

class SdrGrafSetItem : public SfxSetItem
{
public:

	TYPEINFO();

	SdrGrafSetItem( SfxItemSet* pItemSet ) : SfxSetItem( SDRATTRSET_GRAF, pItemSet ) {}
	SdrGrafSetItem( SfxItemPool* pItemPool ) : SfxSetItem( SDRATTRSET_GRAF, new SfxItemSet( *pItemPool, SDRATTR_GRAF_FIRST, SDRATTR_GRAF_LAST ) ) {}
	SdrGrafSetItem( const SdrGrafSetItem& rAttr, SfxItemPool* pItemPool = NULL ) : SfxSetItem( rAttr, pItemPool ) {}
	virtual SfxPoolItem* Clone( SfxItemPool* pToPool ) const;
	virtual SfxPoolItem* Create( SvStream& rStream, USHORT nVersion ) const;
};

}//end of namespace binfilter
#endif // _SDGRSITM_HXX
