/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ChXChartDrawPage.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _CHXCHARTDRAWPAGE_HXX_
#define _CHXCHARTDRAWPAGE_HXX_

#ifndef _SVX_UNOWPAGE_HXX
#include <bf_svx/unopage.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

// header for SvxItemPropertySet
#ifndef SVX_UNOPROV_HXX
#include <bf_svx/unoprov.hxx>
#endif
namespace binfilter {

class ChartModel;

class ChXChartDrawPage :
	public ::com::sun::star::beans::XPropertySet,
	public SvxDrawPage
{
private:
	ChartModel*			mpModel;
	SvxItemPropertySet	maPropSet;

	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > maTypeSequence;

public:
	ChXChartDrawPage( ChartModel* pModel );
	virtual ~ChXChartDrawPage() throw();

	// XInterface
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType )
		throw( ::com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL acquire() throw();
    virtual void SAL_CALL release() throw();

	// XTypeProvider
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes()
		throw( ::com::sun::star::uno::RuntimeException );
    virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId()
		throw( ::com::sun::star::uno::RuntimeException );

	// XPropertySet
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo()
		throw( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL setPropertyValue( const ::rtl::OUString& aPropertyName,
											const ::com::sun::star::uno::Any& aValue )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::beans::PropertyVetoException,
			   ::com::sun::star::lang::IllegalArgumentException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual ::com::sun::star::uno::Any SAL_CALL getPropertyValue( const ::rtl::OUString& PropertyName )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL addPropertyChangeListener( const ::rtl::OUString& aPropertyName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL removePropertyChangeListener( const ::rtl::OUString& aPropertyName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& aListener )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL addVetoableChangeListener( const ::rtl::OUString& PropertyName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL removeVetoableChangeListener( const ::rtl::OUString& PropertyName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener )
		throw( ::com::sun::star::beans::UnknownPropertyException,
			   ::com::sun::star::lang::WrappedTargetException,
			   ::com::sun::star::uno::RuntimeException );
};

} //namespace binfilter
#endif	// _CHXCHARTDRAWPAGE_HXX_
