/*
 * Copyright (C), 2000-2007 by the monit project group.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/**
 *  System dependent device methods.
 *
 *  @author Jan-Henrik Haukeland, <hauk@tildeslash.com>
 *  @author Martin Pala, <martinp@tildeslash.com>
 *
 *  @version \$Id: sysdep_AIX.c,v 1.13 2007/07/25 12:54:31 hauk Exp $
 *
 *  @file
 */

#include <config.h>

#include "monitor.h"
#include "device_sysdep.h"

/**
 * Unknown OS special block device dummy mountpoint method.
 *
 * @param inf      Information structure
 * @param blockdev Identifies block special device
 * @return         NULL
 */
char *device_mountpoint_sysdep(Info_T inf, char *blockdev) {

  LogError("%s: Unsupported mounted filesystem information method", prog);

  return NULL;

}


/**
 * Unknown OS filesystem dummy usage statistics.
 *
 * @param inf Information structure
 * @return    FALSE
 */
int device_usage_sysdep(Info_T inf) {

  LogError("%s: Unsupported filesystem informations gathering method\n", prog);

  return FALSE;

}

