/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QBuffer>
#include <QHttpResponseHeader>

#include "ui_player.h"

#include "stationdialog.h"

class QMovie;

class CoverLoader;
class ImageFader;
class Playback;
class SettingsDialog;
class Song;
class TagDialog;
class TrayIcon;
class WebserviceConnector;

class Player : public QMainWindow
{
    Q_OBJECT

    public:
        Player( QWidget *parent = 0, QString commandLine = QString( "" ) );
        ~Player();

        static bool Player::transmitCli( QString parameter );


    protected:
        void closeEvent( QCloseEvent *event );

    private:
        Ui::PlayerForm ui;

        WebserviceConnector *m_wsConnector;
        Playback *m_playback;
        StationDialog *m_stationDialog;
        TagDialog *m_tagDialog;
        TrayIcon *m_trayIcon;

        QTimer *m_timer;
        CoverLoader *m_coverLoader;
        QBuffer *m_coverBuffer;
        QUrl m_streamUrl;

        QMenu *menu;
        QAction *stationAction;
        QAction *urlAction;
        QAction *recordAction;
        QAction *discoveryAction;
        QAction *refreshAction;
        QAction *configureAction;
        QAction *externalPlayerAction;
        QAction *onTopAction;
        QAction *aboutAction;
        QAction *loveAction;
        QAction *skipAction;
        QAction *banAction;

        ImageFader *m_fader;
        QMovie *m_animation;
        bool m_proxyConnected;

        void loadDefaultCover();

        void dragEnterEvent( QDragEnterEvent *event );
        void dropEvent( QDropEvent *event );

    public slots:
        void handshake();

        void skipPrepared();
        void lovePrepared();
        void banPrepared();

        void setStayOnTop( bool checked );
        void useExternalPlayer( bool checked );

    private slots:
        void init();
        void restoreWindow() { showNormal(); activateWindow(); raise(); }

        void openAbout();
        void openJournalMenu();
        void openMenu();
        void openSettingsDialog();
        void openStationDialog();
        void openTagDialog();
        void openUrlDialog();

        void freeStationDialog() { m_stationDialog->deleteLater(); m_stationDialog = 0; }
//         void freeTagDialog() { m_tagDialog->deleteLater(); m_tagDialog = 0; }

        void handshakeResult( bool connected, bool loginDone, const QUrl& streamUrl );
        void metaDataResult( const Song& song, bool discovery );
        void changeStationPrepared();
        void changeStationResult( bool error );

        void animationStart();
        void animationStop();
        void coverLoaded( bool error );
        void updateTimeBar();

        void playbackStarting();
        void playbackFinished();
        void volumeChanged( int value );
        void togglePlayback();

        void browseArtist();
        void browseAlbum();
        void browseTrack();

        void journalArtist();
        void journalAlbum();
        void journalTrack();

        void proxyClientConnected();
        void proxyClientDisconnected();
};
