/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is CaScadeS, a stylesheet editor for Composer.
 *
 * The Initial Developer of the Original Code is
 * Daniel Glazman.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Original author: Daniel Glazman <daniel@glazman.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const kclCSS1  = 0;
const kclCSS2  = 1;
const kclCSS3  = 2;

const kbNS4    = 3;
const kbGECKO  = 4;
const kbWINIE4 = 5;
const kbWINIE5 = 6;
const kbOPERA6 = 7;

const kCompatibilities = {
  CSS1:   kclCSS1    ,
  CSS2:   kclCSS2    ,
  CSS3:   kclCSS3    ,
  NS4:    kbNS4      ,
  GECKO:  kbGECKO    ,
  WINIE4: kbWINIE4   ,
  WINIE5: kbWINIE5   ,
  OPERA6: kbOPERA6   
};

const kButtonCompatibilityArray = [
  "atimportButton",                    "11",
  "atmediaButton",                     "10",
  "fontFamilyRadiogroup",              "11",
  "noFontFamilyRadio",                 "11",
  "predefFontFamilyRadio",             "11",
  "predefFontFamilyMenulist",          "11",
  "sansSerifFontFamilyMenuitem",       "11",
  "serifFontFamilyMenuitem",           "11",
  "monospaceFontFamilyMenuitem",       "11",
  "customFontFamilyRadio",             "11",
  "customFontFamilyInput",             "11",
  "fontSizeInput",                     "11",
  "lineHeightInput",                   "11",
  "textColorInput",                    "11",
  "colorButton",                       "11",
  "textCW",                            "11",
  "fontWeightMenulist",                "11",
  "unspecifiedFontWeightMenu",         "11",
  "normalFontWeightMenu",              "11",
  "boldFontWeightMenu",                "11",
  "bolderFontWeightMenu",              "11",
  "lighterFontWeightMenu",             "11",
  "inheritFontWeightMenu",             "10",
  "fontStyleMenulist",                 "11",
  "unspecifiedFontStyleMenu",          "11",
  "italicFontStyleMenu",               "11",
  "obliqueFontStyleMenu",              "11",
  "inheritFontStyleMenu",              "10",
  "textTransformMenulist",             "11",
  "unspecifiedTextTransformMenu",      "11",
  "noneTextTransformMenu",             "11",
  "lowercaseTextTransformMenu",        "11",
  "uppercaseTextTransformMenu",        "11",
  "capitalizeTextTransformMenu",       "11",
  "inheritTextTransformMenu",          "10",
  "textAlignMenulist",                 "11",
  "unspecifiedTextAlignMenu",          "11",
  "leftTextAlignMenu",                 "11",
  "rightTextAlignMenu",                "11",
  "centerTextAlignMenu",               "11",
  "justifyTextAlignMenu",              "11",
  "overlineTextDecorationCheckbox",    "11",
  "noneTextDecorationCheckbox",        "11",
  "linethroughTextDecorationCheckbox", "11",
  "underlineTextDecorationCheckbox",   "11",
  "blinkTextDecorationCheckbox",       "11",
  "backgroundColorInput",              "11",
  "backgroundcolorButton",             "11",
  "backgroundCW",                      "11",
  "opacityScrollbar",                  "00",
  "opacityLabel",                      "00",
  "backgroundImageInput",              "11",
  "backgroundRepeatLabel",             "11",
  "backgroundRepeatMenulist",          "11",
  "norepeatBackgroundRepeatMenu",      "11",
  "horizontallyBackgroundRepeatMenu",  "11",
  "verticallyBackgroundRepeatMenu",    "11",
  "repeatBackgroundRepeatMenu",        "11",
  "backgroundAttachmentCheckbox",      "11",
  "backgroundPositionLabel",           "11",
  "xBackgroundPositionRadiogroup",     "11",
  "leftXBackgroundPositionRadio",      "11",
  "centerXBackgroundPositionRadio",    "11",
  "rightXBackgroundPositionRadio",     "11",
  "yBackgroundPositionRadiogroup",     "11",
  "topYBackgroundPositionRadio",       "11",
  "centerYBackgroundPositionRadio",    "11",
  "bottomYBackgroundPositionRadio",    "11",
  "topBorderStyleMenulist",            "11",
  "unspecifiedtopBorderStyle",         "11",
  "nonetopBorderStyle",                "11",
  "hiddentopBorderStyle",              "10",
  "solidtopBorderStyle",               "11",
  "dottedtopBorderStyle",              "11",
  "dashedtopBorderStyle",              "11",
  "doubletopBorderStyle",              "11",
  "groovetopBorderStyle",              "11",
  "ridgetopBorderStyle",               "11",
  "insettopBorderStyle",               "11",
  "outsettopBorderStyle",              "11",
  "topBorderWidthInput",               "11",
  "topBorderColorInput",               "11",
  "topBorderColorButton",              "11",
  "bordertopCW",                       "11",
  "leftBorderStyleMenulist",           "11",
  "unspecifiedleftBorderStyle",        "11",
  "noneleftBorderStyle",               "11",
  "hiddenleftBorderStyle",             "10",
  "solidleftBorderStyle",              "11",
  "dottedleftBorderStyle",             "11",
  "dashedleftBorderStyle",             "11",
  "doubleleftBorderStyle",             "11",
  "grooveleftBorderStyle",             "11",
  "ridgeleftBorderStyle",              "11",
  "insetleftBorderStyle",              "11",
  "outsetleftBorderStyle",             "11",
  "leftBorderWidthInput",              "11",
  "leftBorderColorInput",              "11",
  "leftBorderColorButton",             "11",
  "borderleftCW",                      "11",
  "rightBorderStyleMenulist",          "11",
  "unspecifiedrightBorderStyle",       "11",
  "nonerightBorderStyle",              "11",
  "hiddenrightBorderStyle",            "10",
  "solidrightBorderStyle",             "11",
  "dottedrightBorderStyle",            "11",
  "dashedrightBorderStyle",            "11",
  "doublerightBorderStyle",            "11",
  "grooverightBorderStyle",            "11",
  "ridgerightBorderStyle",             "11",
  "insetrightBorderStyle",             "11",
  "outsetrightBorderStyle",            "11",
  "rightBorderWidthInput",             "11",
  "rightBorderColorInput",             "11",
  "rightBorderColorButton",            "11",
  "borderrightCW",                     "11",
  "bottomBorderStyleMenulist",         "11",
  "unspecifiedbottomBorderStyle",      "11",
  "nonebottomBorderStyle",             "10",
  "hiddenbottomBorderStyle",           "11",
  "solidbottomBorderStyle",            "11",
  "dottedbottomBorderStyle",           "11",
  "dashedbottomBorderStyle",           "11",
  "doublebottomBorderStyle",           "11",
  "groovebottomBorderStyle",           "11",
  "ridgebottomBorderStyle",            "11",
  "insetbottomBorderStyle",            "11",
  "outsetbottomBorderStyle",           "11",
  "bottomBorderWidthInput",            "11",
  "bottomBorderColorInput",            "11",
  "bottomBorderColorButton",           "11",
  "borderbottomCW",                    "11",
  "displayMenulist",                   "11",
  "unspecifiedDisplayMenuitem",        "11",
  "noneDisplayMenuitem",               "11",
  "inlineDisplayMenuitem",             "11",
  "blockDisplayMenuitem",              "11",
  "runinDisplayMenuitem",              "10",
  "compactDisplayMenuitem",            "10",
  "listitemDisplayMenuitem",           "11",
  "tableDisplayMenuitem",              "10",
  "tablerowDisplayMenuitem",           "10",
  "tablecellDisplayMenuitem",          "10",
  "tablecaptionDisplayMenuitem",       "10",
  "inlinetableDisplayMenuitem",        "10",
  "tablecolumnDisplayMenuitem",        "10",
  "tablerowgroupDisplayMenuitem",      "10",
  "tableheadergroupDisplayMenuitem",   "10",
  "tablefootergroupDisplayMenuitem",   "10",
  "tablecolumngroupDisplayMenuitem",   "10",
  "visibilityMenulist",                "10",
  "unspecifiedVisibilityMenuitem",     "10",
  "visibleVisibilityMenuitem",         "10",
  "hiddenVisibilityMenuitem",          "10",
  "collapseVisibilityMenuitem",        "10",
  "floatMenulist",                     "11",
  "unspecifiedFloatMenuitem",          "11",
  "leftFloatMenuitem",                 "11",
  "rightFloatMenuitem",                "11",
  "noneFloatMenuitem",                 "11",
  "clearMenulist",                     "11",
  "unspecifiedClearMenuitem",          "11",
  "noneClearMenuitem",                 "11",
  "leftClearMenuitem",                 "11",
  "rightClearMenuitem",                "11",
  "bothClearMenuitem",                 "11",
  "positionMenulist",                  "10",
  "unspecifiedPositionMenuitem",       "10",
  "staticPositionMenuitem",            "10",
  "fixedPositionMenuitem",             "10",
  "absolutePositionMenuitem",          "10",
  "relativePositionMenuitem",          "10",
  "overflowMenulist",                  "10",
  "unspecifiedOverflowMenuitem",       "10",
  "visibleOverflowMenuitem",           "10",
  "hiddenOverflowMenuitem",            "10",
  "scrollOverflowMenuitem",            "10",
  "autoOverflowMenuitem",              "10",
  "zindexInput",                       "10",
  "widthEditableMenulist",             "11",
  "heightEditableMenulist",            "11",
  "minwidthEditableMenulist",          "10",
  "minheightEditableMenulist",         "10",
  "maxwidthEditableMenulist",          "10",
  "maxheightEditableMenulist",         "10",
  "margintopEditableMenulist",         "11",
  "paddingtopEditableMenulist",        "11",
  "topEditableMenulist",               "10",
  "marginleftEditableMenulist",        "11",
  "paddingleftEditableMenulist",       "11",
  "leftEditableMenulist",              "10",
  "marginrightEditableMenulist",       "11",
  "paddingrightEditableMenulist",      "11",
  "rightEditableMenulist",             "10",
  "marginbottomEditableMenulist",      "11",
  "paddingbottomEditableMenulist",     "11",
  "bottomEditableMenulist",            "10",
  "volumeScrollbar",                   "10",
  "volumeMenulist",                    "10",
  "muteVolumeCheckbox",                "10",
  "speakMenulist",                     "10",
  "unspecifiedSpeakMenu",              "10",
  "noneSpeakMenu",                     "10",
  "normalSpeakMenu",                   "10",
  "spelloutSpeakMenu",                 "10",
  "speechRateMenulist",                "10",
  "unspecifiedSpeechRateMenu",         "10",
  "slowerSpeechRateMenu",              "10",
  "fasterSpeechRateMenu",              "10",
  "xslowSpeechRateMenu",               "10",
  "slowSpeechRateMenu",                "10",
  "mediumSpeechRateMenu",              "10",
  "fastSpeechRateMenu",                "10",
  "xfastSpeechRateMenu",               "10",
  "cueBeforeInput",                    "10",
  "cueAfterInput",                     "10",
  ""
];

