/***************************************************************************
                          proxywidget.cpp  -  description
                             -------------------
    begin                : ?  5? 13 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qvariant.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "proxywidget.h"
//#include "../network/msnconnection.h"

ProxyWidget::ProxyWidget(QWidget* parent, const char* name, WFlags fl )
:ProxyWidgetInterface(parent, name, fl )
{
}
ProxyWidget::~ProxyWidget(){
}
/** No descriptions */
void ProxyWidget::loadProxySettings(Account *account)
{
    bool useproxy=account->getUseProxy();
    proxyTypeComboBox_->setCurrentItem((int)account->getProxyType());
    serverLineEdit_->setText(account->getProxyServer());
    portSpinBox_->setValue(account->getProxyPort());
    uidLineEdit_->setText(account->getProxyUID());
    passwordLineEdit_->setText(account->getProxyPassword());  
    setEnabledStatus(useproxy);
}
//-------------
/** No descriptions */
void ProxyWidget::setEnabledStatus(bool enable)
{
    useProxyCheckBox_->setChecked(enable);
    setEnableProxyType(enable);
    setEnableProxyServer(enable);
    bool auth=(enable)&&(proxyTypeComboBox_->currentItem()==2);//SOCKS5,thus needs auth
    setEnableProxyAuth(auth);
}    
void ProxyWidget::useProxyToggled(bool useproxy)
{
    setEnabledStatus(useproxy);
}
//--------------------------------
void ProxyWidget::setEnableProxyType(bool enable)
{
    typeLabel_->setEnabled(enable);
    proxyTypeComboBox_->setEnabled(enable);

}
//--------------------------------
void ProxyWidget::setEnableProxyServer(bool enable)
{
    serverLabel_->setEnabled(enable);
    portLabel_->setEnabled(enable);
    portSpinBox_->setEnabled(enable);
    serverLineEdit_->setEnabled(enable);
    
}
//--------------------------------
void ProxyWidget::setEnableProxyAuth(bool enable)
{
    uidLabel_->setEnabled(enable);
    uidLineEdit_->setEnabled(enable);
    passwordLabel_->setEnabled(enable);
    passwordLineEdit_->setEnabled(enable);
}
//---------------
void ProxyWidget::proxyTypeChanged(int index)
{
    bool auth=(index==2);//TYPE_SOCKS5);
    setEnableProxyAuth(auth);
}
