/***************************************************************************
                          notificationwidget.cpp  -  description
                             -------------------
    begin                : Tue May 20 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "notificationwidget.h"

#include <qcolor.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <qwidget.h>

#include <kdebug.h>
#include <kurllabel.h>

#include "notificationitem.h"


NotificationWidget::NotificationWidget( QWidget *parent, const char *name )
  : CurvedWidget( parent,name )
{
  setIndent( 0 );

  pixmapLayout_ = new QHBoxLayout( 0, 0, 5, "pixmapLayout_" );
  getRootLayout()->addLayout( pixmapLayout_, 0, 0 );

  pixmapLabel_ = new QLabel( this, "pixmapLabel_" );
  pixmapLayout_->addWidget( pixmapLabel_ );

  listLayout_ = new QVBoxLayout( 0, 0, 2, "listLayout_" );
  pixmapLayout_->addLayout( listLayout_ );

  label_ = new QLabel( this );
  label_->setAlignment( AlignAuto | AlignVCenter | WordBreak );
  label_->setMinimumWidth( 100 );
  listLayout_->addWidget( label_ );

  notificationItems_.clear();

  // we are empty when first created ;)
  hide();

  setSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum );

  recreateLabel();
}

NotificationWidget::~NotificationWidget()
{
  delete listLayout_;
  delete pixmapLayout_;
}



// event handler, for seeing when something is added to us/deleted from us
bool NotificationWidget::event( QEvent *event )
{
  bool theirReturnCode;

  NotificationItem *childObject = (NotificationItem *) ((QChildEvent *) event)->child();

  theirReturnCode = CurvedWidget::event( event );

  if ( event->type() == QEvent::ChildInserted )
  {
    if ( childObject->inherits( "NotificationItem" ) )
    {
      notificationItems_.append( childObject );

      pixmapLabel_->setPixmap( childObject->getPixmap() );

      listLayout_->insertWidget( -1, childObject->getWidget() );

      recreateLabel();

      emit full( this );

      connect( childObject,   SIGNAL( forwardClicked( QStringList, QObject * ) ),
               this,            SLOT( forwardClicked( QStringList, QObject * ) ) );

      return true;
    }
  }

  if ( event->type() == QEvent::ChildRemoved )
  {
    if ( notificationItems_.contains( childObject ) )
    {
#ifdef KMESSDEBUG_POPUPNOTIFICATION
      kdDebug() << "Removing child widget" << endl;
      kdDebug() << "Removing from list of items" << endl;
#endif
      notificationItems_.remove( childObject );

#ifdef KMESSDEBUG_POPUPNOTIFICATION
      kdDebug() << "Recreating label" << endl;
#endif
      recreateLabel();

      if ( notificationItems_.isEmpty() )
      {
#ifdef KMESSDEBUG_POPUPNOTIFICATION
        kdDebug() << "Emitting empty() signal" << endl;
#endif
        emit empty( this );
      }
      else
      {
#ifdef KMESSDEBUG_POPUPNOTIFICATION
        kdDebug() << "Changing pixmap" << endl;
        kdDebug() << "No of items is " << notificationItems_.count() << endl;
#endif
        pixmapLabel_->setPixmap( notificationItems_.last()->getPixmap() );
      }
#ifdef KMESSDEBUG_POPUPNOTIFICATION
      kdDebug() << "Done" << endl;
#endif

      return true;
    }
  }

  return theirReturnCode;
}



void NotificationWidget::forwardClicked( QStringList strings, QObject *object )
{
  emit clicked( strings, object );
}



// make up our label ;)
void NotificationWidget::recreateLabel()
{
  NotificationItem *notificationItem;

  label_->setText( caption() ) ;

   for ( notificationItem = notificationItems_.first();
        notificationItem; notificationItem = notificationItems_.next() )
  {
    notificationItem->getWidget()->show();

    notificationItem->getWidget()->adjustSize();
  }

}

#include "notificationwidget.moc"
