/***************************************************************************
                          kmesslistviewitem.cpp  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmesslistviewitem.h"

#include "kmessdebug.h"

#include <qcolor.h>
#include <qmime.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qsimplerichtext.h>

#include <kdebug.h>

#ifdef KMESSDEBUG_KMESSLISTVIEWITEM
#define KMESSDEBUG_KMESSLISTVIEWITEM_GENERAL
#endif


// The constructor
KMessListViewItem::KMessListViewItem(QListView *parent)
 : QListViewItem( parent ),
   richText_(0),
   widthText_(0),
   listParent_(parent)
{
  setMultiLinesEnabled( false );
  recreateRichText("");
}



// The constructor
KMessListViewItem::KMessListViewItem(QListViewItem *parent)
 : QListViewItem( parent ),
   richText_(0),
   widthText_(0),
   listParent_(0)
{
  setMultiLinesEnabled( false );
  recreateRichText("");
}



// The destructor
KMessListViewItem::~KMessListViewItem()
{
  if (  richText_ != 0 ) delete  richText_;
  if ( widthText_ != 0 ) delete widthText_;
}



// // Compare
// int KMessListViewItem::compare( QListViewItem *item, int /* col */, bool /* asc */) const
// {
// #ifdef KMESSTEST
//   ASSERT( dynamic_cast<KMessListViewItem *>(item) != 0 );
// #endif
//
//   int thisType = this->getType(); // Is overwritten in sub classes
//   int thatType = static_cast<KMessListViewItem *>(item) -> getType();
//
//   if(thisType == thatType)         return  0; // Equal.
//   if(thisType == LISTTYPE_CONTACT) return -1; // Contact is smaller, show individual contacts above the groups.
//   return 1; // "Group" and "base" are greather, sort at the bottom.
// }



// Return the type ID
int KMessListViewItem::getType() const
{
  return LISTTYPE_BASE;
}


// Paint a cell (column 0, always) - this allows us emoticons, through QSimpleRichText
void KMessListViewItem::paintCell( QPainter * painter, const QColorGroup & colourGroup, int column, int width, int align )
{
  if ( column == 0)
  {
    QBrush *brush;
    QPalette palette;
    QRect itemRectangle;

    palette = listView()->viewport()->palette();
    brush   = 0;

    itemRectangle = listView()->itemRect( this );
    itemRectangle.setX( listView()->treeStepSize() * depth() );

    listView()->viewport()->erase( itemRectangle );

    if ( isSelected() )
    {
      brush = new QBrush( palette.color(QPalette::Active, QColorGroup::Highlight) );
      // painter->setPen( palette.color(QPalette::Active, QColorGroup::Text) );
    }
    else
    {
      // painter->setPen( palette.color(QPalette::Normal, QColorGroup::Text) );
    }

    // TODO: Change the font for highlighted text
    richText_->draw( painter, listView()->itemMargin(), 0, QRect( 0, 0, width, height() ), colourGroup, brush );
    setHeight( richText_->height() );
    widthChanged( 0 );

    delete brush;
  }
  else
  {
    QListViewItem::paintCell( painter, colourGroup, column, width, align );
  }
}



// Recreate the rich text
void KMessListViewItem::recreateRichText(const QString &text)
{
  // Delete the existing rich text
  if ( richText_ != 0 )
  {
    delete richText_;
    richText_ = 0;
  }

  // Delete the existing width text
  if ( widthText_ != 0 )
  {
    delete widthText_;
    widthText_ = 0;
  }


  // Create a new rich text object
  richText_ = new QSimpleRichText( "<qt><nobr>" + text + "</nobr></qt>",
                                   listView()->viewport()->font(), QString::null, 0/*, mimeFactory_*/ );
  // TODO: use the QMimeSourceFactory parameter to load all graphics only once.

  // Creat a rich text object with 8bit characters to get the correct size
  QCString         local8BitText = text.local8Bit();
  QSimpleRichText *widthText_    = new QSimpleRichText( "<qt><nobr>" + local8BitText + "</nobr></qt>",
                                                        listView()->viewport()->font(), QString::null, 0/*, mimeFactory_*/ );


  //richText_->adjustSize();
  richText_->setWidth( widthText_->widthUsed() );

  // Tell the listview to re-calculate it's width
  widthChanged(0);
}


// Re-sort the parent nodes
void KMessListViewItem::resortParent()
{
  // Ask parent to re-run the sorting algorithm
  if(QListViewItem::parent() != 0)
  {
    QListViewItem::parent()->sort();
  }
  else if(listParent_ != 0)
  {
    // FIXME: remove this if the QListViewItem::parent() also works for listviews
    listParent_->sort();
  }
#ifdef KMESSDEBUG_KMESSLISTVIEWITEM_GENERAL
  else
  {
    kdDebug() << "KMessListViewItem::resortParent: No parent found!" << endl;
  }
#endif
}


// dummy setText method
void KMessListViewItem::setHTMLText(const QString &text)
{
  recreateRichText(text);
  repaint();
}



// returns the width of the text in the column
int KMessListViewItem::width( const QFontMetrics & fm, const QListView * lv, int c) const
{
  if(c == 0)
  {
    return richText_->width();
  }

  return QListViewItem::width( fm, lv, c );
}
