/***************************************************************************
                          systemtraywidget.h  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSTEMTRAYWIDGET_H
#define SYSTEMTRAYWIDGET_H

#include <qwidget.h>
#include <ksystemtray.h>

// Forward declaration
class CurrentAccount;

/**The system tray widget displays the user's status in the system tray and gives access to some settings.
  *@author Mike K. Bennett
  */

class SystemTrayWidget : public KSystemTray
{
  Q_OBJECT

  public:
    // The constructor
  	                 SystemTrayWidget(QWidget *parent=0, const char *name=0);
    // The destructor
  	                ~SystemTrayWidget();
    // Initialize the class
    bool             initialize();
    // Return the context menu
    KPopupMenu      *menu() const;

  private slots: // Private slots
    // Change the icon when the user's status changes
    void             statusChanged();

  private: // Private attributes
    // A pointer to the instance of the current account
    CurrentAccount  *currentAccount_;

};

#endif
