/***************************************************************************
                          msnremotedesktop.cpp  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "msnremotedesktop.h"

#include <qprocess.h>

#include <kdebug.h>
#include <klocale.h>

#include "../../kmessdebug.h"
#include "../mimemessage.h"

// The constructor
MsnRemoteDesktop::MsnRemoteDesktop(const QString& localIp)
 : MimeApplication(localIp)
{
}



// The destructor
MsnRemoteDesktop::~MsnRemoteDesktop()
{
}



// Step one of a contact-started chat: the contact invites the user
void MsnRemoteDesktop::contactStarted1_ContactInvitesUser(const MimeMessage& /*message*/)
{
#ifdef KMESSDEBUG_REMOTEDESKTOP
  kdDebug() << "MsnRemoteDesktop - contactStarted1_ContactInvitesUser" << endl;
#endif

  // Send the message to the chat window.
  offerAcceptOrReject( i18n("You are invited to share this person's desktop.") );
}



// Step two of a contact-started chat: the user accepts
void MsnRemoteDesktop::contactStarted2_UserAccepts()
{
#ifdef KMESSDEBUG_REMOTEDESKTOP
  kdDebug() << "MsnRemoteDesktop - contactStarted2_UserAccepts" << endl;
#endif

  // Create the accept message
  MimeMessage message;
  message.addField( "Invitation-Command", "ACCEPT"         );
  message.addField( "Invitation-Cookie",  getCookie()      );
  message.addField( "Session-ID",         getSessionId()   );
  message.addField( "Session-Protocol",   "SM1"            );
  message.addField( "Launch-Application", "TRUE"           );
  message.addField( "Request-Data",       "IP-Address:"    );
  message.addField( "IP-Address",         getExternalIp()  );

  sendMessage( message );
}



// Step three of a contact-started chat: the contact confirms the accept
void MsnRemoteDesktop::contactStarted3_ContactConfirmsAccept(const MimeMessage& message)
{
#ifdef KMESSDEBUG_REMOTEDESKTOP
  kdDebug() << "MsnRemoteDesktop - contactStarted3_ContactConfirmsAccept" << endl;
#endif

  // Store the data from the message
  remoteIp_ = message.getValue("IP-Address");

  // The message context field contains something like:
  // (added newlines for readability)
  // Context:: 48;
  // ET=0.0.0.0:5002;
  // User-0925:4557;
  // <external ip>:4557119;
  // PK=BgIAAACkAABSU0ExAAIAAAEAAQCVdaHLzNverlz3mYpARdO+qzX0GHsjrD5drPLW%0D%0A
  //    7NySSYx7QXg+XnCMT46r6RhN9iK9e+yY0LESDwdEF1TlrIqz%0D%0A

  // Send the context
  MimeMessage contextMessage;
  QString contextData;

  // Create the context data
  contextData = "48;ET=0.0.0.0:5002;User-0925:4557;";
  contextData += getExternalIp() + ":4557119;";
  contextData += "PK=BgIAAACkAABSU0ExAAIAAAEAAQCVdaHLzNverlz3mYpARdO+qzX0GHsjrD5drPLW%0D%0A"
                 "7NySSYx7QXg+XnCMT46r6RhN9iK9e+yY0LESDwdEF1TlrIqz%0D%0A";


/*
  // Create the context data
  login = "User-0925";
  password = "BgIAAACkAABSU0ExAAIAAAEAAQCVdaHLzNverlz3mYpARdO+qzX0GHsjrD5drPLW%0D%0A7NySSYx7QXg+XnCMT46r6RhN9iK9e+yY0LESDwdEF1TlrIqz%0D%0A";
  contextData =  "48;ET=0.0.0.0:5002;";
  contextData += login + ":4557;";
  contextData += getExternalIp() + ":4557119;";
  contextData += "PK=" + password;

  // More research on http://www.hypothetic.org/docs/msn/phorum/read.php?f=1&i=2506&t=2506
  // PK likely stands for "public key".
*/

  // Dummy, we don't know the values yet
  QString login    = "User-0925";
  QString password = "4557";

  // Create the context message
  contextMessage.addField( "Invitation-Command", "Context"        );
  contextMessage.addField( "Invitation-Cookie",  getCookie()      );
  contextMessage.addField( "Context-Data:",      contextData      );
  contextMessage.addField( "Session-ID",         getSessionId()   );

  sendMessage( contextMessage );

  // Start kde's remote desktop client
  startRemoteClient(login, password);
}



// Return the application's GUID
QString MsnRemoteDesktop::getAppId()
{
  return "{56b994a7-380f-410b-9985-c809d78c1bdc}";
}



// Start kde's remote desktop client
void MsnRemoteDesktop::startRemoteClient(QString /*login*/, QString /*password*/)
{
#ifdef KMESSDEBUG_REMOTEDESKTOP
  kdDebug() << "MsnRemoteDesktop - Start KDE's remote desktop client." << endl;
#endif

  // Show the user that the app is starting
  emit appMessage( i18n("Starting KRDC.  Connecting to %1.").arg( remoteIp_ ) );

  // Start the app
  QProcess process;
  process.addArgument("krdc");
  QString arg;
//  arg = "rdp://" + login + ":" + password + "@" + remoteIp_;
  arg = "rdp://" + remoteIp_;   // Give a login screen, we can't figure out the password
#ifdef KMESSDEBUG_REMOTEDESKTOP
  kdDebug() << "MsnRemoteDesktop - Argument is " << arg << "." << endl;
#endif
  process.addArgument( arg );
  process.start();

  // Delete the application (which is now finished)
  endApplication();
}

#include "msnremotedesktop.moc"
