/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qevent.h>
#include <qtooltip.h> 

#include <kdebug.h>
#include <klocale.h>

#include "aux.h"
#include "DDataItem.h"
#include "DDataControl.h"
#include "DTreeListView.h"
#include "settings.h"
#include "DTreeListItem.h"

	DTreeListItem::DTreeListItem(DTreeListView *parent, int id)
: KListViewItem(parent),  DGuiItem(parent, id)
{
	if (!data())
	{
		kdWarning()<<"Bug in DTreeListItem ctor"<<endl;
		return;
	}

	setOpen(true);
	KListViewItem::setText(0, data()->dispmsg());
	setDragEnabled(true);
	setDropEnabled(true);
}

DTreeListItem::~DTreeListItem()
{
}

void DTreeListItem::update()
{
	if (!data())
	{
		kdWarning()<<"Bug in DTreeListItemText::update"<<endl;
		return;
	}

	KListViewItem::setText(0, data()->dispmsg()); 
	setPixmap(0, data()->m_pixtb);

	enforceSortOrder();
}

int DTreeListItem::compare(QListViewItem* i, int, bool) const
{
	DTreeListItem *item = (DTreeListItem*) i;
	if (!item)
		return 1;

	return m_parent->dataTree()->compare(item->Id(), Id());
}

void DTreeListItem::paintCell( QPainter* p, const QColorGroup& c, int column, int width, int align )
{
	QColorGroup cg(c);
	cg.setBrush( QColorGroup::Base, data()->fillColor() );
	cg.setBrush( QColorGroup::Text, data()->textColor() );
	cg.setBrush( QColorGroup::HighlightedText, QColor(Qt::white) );
	cg.setBrush( QColorGroup::Highlight, data()->fillColor().dark() );
	QListViewItem::paintCell(p, cg, column, width, align);
}

QString DTreeListItem::tipText()
{
	return "<html>"+data()->dispmsg()+"</html>";
}
