/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qpainter.h>
#include <qcolor.h>
#include <kdebug.h>
#include "DCanvasItem.h"
#include "DCanvasRef.h"
#include "settings.h"

	DCanvasRef::DCanvasRef(QCanvas* canvas, DCanvasItem* orig)
: DCanvasLink(canvas, orig)
{
	m_orig = orig;
	updateColor();
	show();
}

DCanvasRef::~DCanvasRef()
{
	hide();
}

void DCanvasRef::updateColor()
{
	QPen pen;
	pen.setStyle( DotLine );
	pen.setWidth( m_orig->control()->m_showDirectionSize );

	QBrush brush;
	brush.setStyle( QBrush::Dense5Pattern );
	brush.setColor( QColor( m_orig->control()->m_col_ref ) );
	pen.setColor( m_orig->control()->m_col_ref );
	setBrush(brush);
	setPen(pen);
	m_ellipse->setBrush(brush);
	int s = m_orig->control()->m_showDirectionSize;
	m_ellipse->setSize(s+5, s+5);
}
