/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WEATHERPARSER_H
#define WEATHERPARSER_H

#include <qstring.h>
#include <qcstring.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <qtimer.h>

#include "config_file.h"
#include "debug.h"
#include "forecast.h"
#include "citysearchresult.h"

/**
	\class WeatherParser
	Zajmuje si wyowieniem informacji pogodowych ze strony WWW.
**/
class WeatherParser
{
	private:
	
		struct WDataValue
		{
			QString Name;
			QString Start;
			QString End;
			QString Content;
		};
		
		bool getDataValue( const QString& page, WDataValue& wdata, int& cursor, const PlainConfigFile* wConfig, bool CaseSensitive) const;
		const QString& tagClean( QString ) const;
		
	public:
		WeatherParser();
		
		bool getData( const QString& page, const PlainConfigFile* wConfig, Forecast& forecast ) const;
		
		/**
			Parsuje wyniki wyszukiwania
			\param page pobrana witryna
			\param wConfig konfiguracja serwisu pogodowego
			\param result wyniki parsowania: klucz - nazwa, dana - kod miejscowoci
		**/
		void getSearch(const QString& page, const PlainConfigFile* wConfig, const QString& serverConfigFile , CITYSEARCHRESULTS* results ) const;
		QString getFastSearch(const QString& link, const PlainConfigFile* wConfig) const;
};

#endif // WEATHERPARSER_H
