/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <qlistview.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qheader.h>

#include "kadu.h"
#include "userbox.h"
#include "userlist.h"
#include "config_dialog.h"
#include "message_box.h"
#include "icons_manager.h"

#include "weather.h"
#include "show_forecast_dialog.h"
#include "getcitydialog.h"
#include "weather_global.h"
#include "citysearchresult.h"

WeatherGlobal* weather_global;
Weather* weather_session;

extern "C" int weather_init()
{
	weather_global = new WeatherGlobal;
    weather_session = new Weather;

    return 0;
}

extern "C" void weather_close()
{	
    delete weather_session;
	delete weather_global;
}

/**
	Weather
**/
Weather::Weather()
{
	// Contacts parameters
	userlist->addPerContactNonProtocolConfigEntry( "city", "City" );
	userlist->addPerContactNonProtocolConfigEntry( "weather", "WeatherData" );

	// Config parameters
	//
	config_file.addVariable("Weather", "HintFont", QFont("Helvetica", 11));
	config_file.addVariable("Weather", "HintDay", 0);
	config_file.addVariable("Weather", "DescriptionDay", 0);
	config_file.addVariable("Weather", "HintText", tr("<u>%l</u> - <b>%d:</b><br>Temperature: %t<br>Pressure: %p"));
	config_file.addVariable("Weather", "DescriptionText", tr("Temperature in %l: %t"));

	ConfigDialog::addTab(QT_TRANSLATE_NOOP("@default", "Weather"),"WeatherTab");
	
	// "Weather servers" section
	//
	ConfigDialog::addVGroupBox("Weather", "Weather", QT_TRANSLATE_NOOP("@default", "Weather servers"));
	ConfigDialog::addLabel( "Weather", "Weather servers", QT_TRANSLATE_NOOP("@default", "Servers selection and search sequence:") );
	ConfigDialog::addHBox( "Weather", "Weather servers", "serversHBox" );
	ConfigDialog::addListView( "Weather", "serversHBox", "serverList" );
	ConfigDialog::addVBox( "Weather", "serversHBox", "serverListButtonsBox" );
	ConfigDialog::addPushButton( "Weather", "serverListButtonsBox", QT_TRANSLATE_NOOP("@default", "Up") );
	ConfigDialog::addPushButton( "Weather", "serverListButtonsBox", QT_TRANSLATE_NOOP("@default", "Down") );

	// "Options" section
	//
	ConfigDialog::addVGroupBox("Weather", "Weather", QT_TRANSLATE_NOOP("@default", "Options"), 0, Advanced);
	ConfigDialog::addCheckBox( "Weather", "Options",
			QT_TRANSLATE_NOOP("@default","Auto-download new forecast for me"),
			"bAuto", false);
	QStringList comboText = QStringList::split(',', tr("Today,Tomorrow,The day after tomorrow"));
	QStringList comboValues = QStringList::split(',', "0,1,2");
	ConfigDialog::addHBox("Weather", "Options", "hint_box");
	ConfigDialog::addCheckBox( "Weather", "hint_box",
			QT_TRANSLATE_NOOP("@default","Show hint:"),
			"bHint", true);
	
	QString legendTip = QT_TRANSLATE_NOOP("@default","%l - location\n%d - day\n%t - temperature\n%o - description\n%w - wind speed\n%p - pressure\n%T - download time");
	ConfigDialog::addLineEdit( "Weather", "hint_box", "","HintText","", legendTip.ascii(), "hint_text");
	ConfigDialog::addComboBox( "Weather", "hint_box", "", "HintDay", comboText, comboValues, "", "", "hint_day");
			
	ConfigDialog::addHBox("Weather", "Options", "desc_box" );
	ConfigDialog::addCheckBox( "Weather", "desc_box", QT_TRANSLATE_NOOP("@default","Update description text:"), "bDescription", false);
	ConfigDialog::addLineEdit( "Weather", "desc_box","","DescriptionText","", legendTip.ascii(), "desc_text");
	ConfigDialog::addComboBox( "Weather", "desc_box", "", "DescriptionDay", comboText, comboValues, "", "", "desc_day");
	
	// "Hints options" section
	//
	ConfigDialog::addVGroupBox("Weather", "Weather", QT_TRANSLATE_NOOP("@default", "Hints options"), 0, Advanced);
	ConfigDialog::addSelectFont( "Weather", "Hints options",
			QT_TRANSLATE_NOOP("@default", "Font:"), "HintFont");
	ConfigDialog::addColorButton( "Weather", "Hints options",
			QT_TRANSLATE_NOOP("@default", "Font color:"), "FontColor", QColor(0,0,0));
	ConfigDialog::addColorButton( "Weather", "Hints options",
			QT_TRANSLATE_NOOP("@default", "Background color:"), "BackgroundColor", QColor(255,255,255));
	ConfigDialog::addSpinBox( "Weather", "Hints options",
			QT_TRANSLATE_NOOP("@default","Hint timeout:"), "HintTimeout", 0, 60, 1, 15);
			
	// "View" section
	//
	ConfigDialog::addVGroupBox("Weather", "Weather", QT_TRANSLATE_NOOP("@default", "View"), 0, Expert);
	ConfigDialog::addCheckBox( "Weather", "View",
			QT_TRANSLATE_NOOP("@default","Show \"Local forecast\" in main menu"), "ShowLocalForecast", true);
	ConfigDialog::addCheckBox( "Weather", "View",
			QT_TRANSLATE_NOOP("@default","Show \"Forecast for...\" in main menu"), "ForecastFor", true);
	ConfigDialog::addCheckBox( "Weather", "View",
			QT_TRANSLATE_NOOP("@default","Show \"Show contact weather\" in contact menu"), "ShowContactWeather", true);
	
	ConfigDialog::registerSlotOnCreateTab("Weather", this, SLOT(CreateConfigDialog()));
	ConfigDialog::registerSlotOnApplyTab("Weather", this, SLOT(ApplyConfigDialog()));
	ConfigDialog::connectSlot("Weather", "serverList",
			SIGNAL(pressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	ConfigDialog::connectSlot("Weather", "serverList",
			SIGNAL(spacePressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	ConfigDialog::connectSlot("Weather", "Up", SIGNAL(clicked()), this, SLOT(upClicked()));
	ConfigDialog::connectSlot("Weather", "Down", SIGNAL(clicked()), this, SLOT(downClicked()));

	ConfigDialog::connectSlot("Weather", "Auto-download new forecast for me", SIGNAL(toggled(bool)),
			this, SLOT(checkedAutoLoad(bool)));
	ConfigDialog::connectSlot("Weather", "Show hint:", SIGNAL(toggled(bool)),
			this, SLOT(checkedShowHints(bool)));
	ConfigDialog::connectSlot("Weather", "Update description text:", SIGNAL(toggled(bool)),
			this, SLOT(checkedDescription(bool)));
	
	if(config_file.readBoolEntry("Weather", "ShowLocalForecast", true))
		menuMyWeather_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Local forecast"),this, SLOT(ShowMyWeather()), 0, -1, 0);
	else
		menuMyWeather_ = -1;
	
	if(config_file.readBoolEntry("Weather", "ForecastFor", true))
		menuWeatherFor_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Forecast for..."), this, SLOT(ShowWeatherFor()), 0, -1, 1);
	else
		menuWeatherFor_ = -1;
	
	menuShowContactWeather_ = config_file.readBoolEntry("Weather", "ShowContactWeather", true);
	if(menuShowContactWeather_)
		UserBox::userboxmenu->addItemAtPos(2,"ShowWeather", tr("Show contact weather"), this, SLOT(ShowWeather()));
	
}

Weather::~Weather()
{
	
	kadu->mainMenu()->removeItem(menuWeatherFor_);
	kadu->mainMenu()->removeItem(menuMyWeather_);
	UserBox::userboxmenu->removeItem(UserBox::userboxmenu->getItem(tr("Show contact weather")));

	ConfigDialog::disconnectSlot("Weather", "Update description text:",
			SIGNAL(toggled(bool)), this, SLOT(checkedDescription(bool)));
	ConfigDialog::disconnectSlot("Weather", "Show hint:",
			SIGNAL(toggled(bool)), this, SLOT(checkedShowHints(bool)));
	ConfigDialog::disconnectSlot("Weather", "Auto-download new forecast for me",
			SIGNAL(toggled(bool)), this, SLOT(checkedAutoLoad(bool)));

	ConfigDialog::disconnectSlot("Weather", "Up", SIGNAL(clicked()), this, SLOT(upClicked()));
	ConfigDialog::disconnectSlot("Weather", "Down", SIGNAL(clicked()), this, SLOT(downClicked()));
	ConfigDialog::disconnectSlot("Weather", "serverList",
			SIGNAL(pressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	ConfigDialog::disconnectSlot("Weather", "serverList",
			SIGNAL(spacePressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	ConfigDialog::unregisterSlotOnApplyTab("Weather", this, SLOT(ApplyConfigDialog()));
	ConfigDialog::unregisterSlotOnCreateTab("Weather", this, SLOT(CreateConfigDialog()));
	
	ConfigDialog::removeControl("Weather", "Show \"Show contact weather\" in contact menu");
	ConfigDialog::removeControl("Weather", "Show \"Forecast for...\" in main menu");
	ConfigDialog::removeControl("Weather", "Show \"Local forecast\" in main menu");
	ConfigDialog::removeControl("Weather", "View");
	
	ConfigDialog::removeControl("Weather", "Hint timeout:");
	ConfigDialog::removeControl("Weather", "Background color:");
	ConfigDialog::removeControl("Weather", "Font color:");
	ConfigDialog::removeControl("Weather", "Font:");
	ConfigDialog::removeControl("Weather", "Hints options");
	
	ConfigDialog::removeControl("Weather", "", "desc_day");
	ConfigDialog::removeControl("Weather", "", "desc_text");
	ConfigDialog::removeControl("Weather", "Update description text:");
	ConfigDialog::removeControl("Weather", "desc_box");
	ConfigDialog::removeControl("Weather", "", "hint_day");
	ConfigDialog::removeControl("Weather", "", "hint_text");
	ConfigDialog::removeControl("Weather", "Show hint:");
	ConfigDialog::removeControl("Weather", "hint_box");
	ConfigDialog::removeControl("Weather", "Auto-download new forecast for me");
	ConfigDialog::removeControl("Weather", "Options");
	
	ConfigDialog::removeControl( "Weather", "Down" );
	ConfigDialog::removeControl( "Weather", "Up" );
	ConfigDialog::removeControl( "Weather", "serverListButtonsBox" );
	ConfigDialog::removeControl( "Weather", "serverList" );
	ConfigDialog::removeControl( "Weather", "serversHBox" );
	ConfigDialog::removeControl( "Weather", "Servers selection and search sequence:" );
	ConfigDialog::removeControl( "Weather", "Weather servers" );
	
	ConfigDialog::removeTab("Weather");
}

void Weather::CreateConfigDialog()
{

	// Weather servers
	//
	QListView* serverList = ConfigDialog::getListView("Weather","serverList");
	serverList->addColumn(tr("Server name"));
	serverList->setColumnWidthMode(0, QListView::Maximum);
	serverList->header()->hide();
	serverList->setAllColumnsShowFocus(true);
	serverList->setResizeMode(QListView::LastColumn);
	serverList->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Minimum));
	serverList->setMaximumHeight( 70 );
	serverList->setSorting( -1 );
		
	WeatherGlobal::SERVERITERATOR serverIt = weather_global->servers_.begin();
	while( serverIt != weather_global->servers_.end() )
	{
		QCheckListItem* item = new QCheckListItem( serverList, (*serverIt).name_, QCheckListItem::CheckBox );
		item->setOn( (*serverIt).use_ );
		item->moveItem( serverList->lastItem() );
		++serverIt;
	}

	ConfigDialog::getSpinBox("Weather", "Hint timeout:")->setSuffix(" s");
	
	checkedShowHints(config_file.readBoolEntry("Weather","bHint", false));
	checkedDescription(config_file.readBoolEntry("Weather","bDescription", false));
	checkedAutoLoad(config_file.readBoolEntry("Weather","bAuto", false));
}

void Weather::ApplyConfigDialog()
{
	// Weather servers
	//
	QListView* serverList = ConfigDialog::getListView("Weather","serverList");
	QCheckListItem* item = reinterpret_cast<QCheckListItem*>( serverList->firstChild() );
	
	uint index = 0;
	while( item != 0 )
	{
		QString itemText = item->text();
		weather_global->setServerUsing( itemText, item->isOn() );
		weather_global->setServerPos( itemText, index );
		item = reinterpret_cast<QCheckListItem*>( item->nextSibling() );
		++index;
	}
	
	if(config_file.readBoolEntry("Weather", "ShowLocalForecast", false) && menuMyWeather_ == -1 )
		menuMyWeather_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Local forecast"),this, SLOT(ShowMyWeather()), 0, -1, 0);
	else if(!config_file.readBoolEntry("Weather", "ShowLocalForecast") && menuMyWeather_ != -1)
	{
		kadu->mainMenu()->removeItem(menuMyWeather_);
		menuMyWeather_ = -1;
	}
	
	if(config_file.readBoolEntry("Weather", "ForecastFor") && menuWeatherFor_ == -1)
		menuWeatherFor_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Forecast for..."), this, SLOT(ShowWeatherFor()), 0, -1, 1);
	else if(!config_file.readBoolEntry("Weather", "ForecastFor") && menuWeatherFor_ != -1)
	{
		kadu->mainMenu()->removeItem(menuWeatherFor_);
		menuWeatherFor_ = -1;
	}
	
	if( config_file.readBoolEntry("Weather", "ShowContactWeather") && !menuShowContactWeather_ )
	{
		UserBox::userboxmenu->addItemAtPos(2,"ShowWeather", tr("Show contact weather"), this, SLOT(ShowWeather()));
		menuShowContactWeather_ = true;
	}
	else if( !config_file.readBoolEntry("Weather", "ShowContactWeather") && menuShowContactWeather_ )
	{
		UserBox::userboxmenu->removeItem(UserBox::userboxmenu->getItem(tr("Show contact weather")));
		menuShowContactWeather_ = false;
	}
	
	emit autoDownloader_.parametersChanged();
}

void Weather::serverListItemChanged( QListViewItem* item )
{
	if( item == 0 )
		return;

	QCheckListItem* checkItem = reinterpret_cast<QCheckListItem*>( item );
	if( checkItem->isOn() )
		return;
	
	QListView* serverList = ConfigDialog::getListView("Weather","serverList");
	QCheckListItem* listItem = reinterpret_cast<QCheckListItem*>( serverList->firstChild() );
	
	while( listItem != 0 )
	{
		if( listItem->isOn() )
			return;
		listItem = reinterpret_cast<QCheckListItem*>( listItem->nextSibling() );
	}
	checkItem->setOn( true );
}

void Weather::upClicked()
{
	QListView* serverList = ConfigDialog::getListView("Weather","serverList");
	QListViewItem* item = serverList->currentItem();
	if( item != 0 )
	{
		QListViewItem* previous = item->itemAbove();
		if( previous != 0 )
			previous->moveItem( item );
	}
}

void Weather::downClicked()
{
	QListView* serverList = ConfigDialog::getListView("Weather","serverList");
	QListViewItem* item = serverList->currentItem();
	if( item != 0 )
	{
		QListViewItem* next = item->itemBelow();
		if( next != 0 )
			item->moveItem( next );
	}
}

void Weather::checkedAutoLoad(bool check)
{
	ConfigDialog::getHBox("Weather", "hint_box")->setEnabled(check);
	ConfigDialog::getHBox("Weather", "desc_box")->setEnabled(check);
	//ConfigDialog::getComboBox("Weather", "Show day:")->setEnabled(check);
}

void Weather::checkedShowHints(bool check)
{
	ConfigDialog::getLineEdit("Weather", "", "hint_text")->setEnabled(check);
	ConfigDialog::getComboBox("Weather", "", "hint_day")->setEnabled(check);
}

void Weather::checkedDescription(bool check)
{
	ConfigDialog::getLineEdit("Weather", "", "desc_text")->setEnabled(check);
	ConfigDialog::getComboBox("Weather", "", "desc_day")->setEnabled(check);
}

void Weather::ShowWeather()
{
	UserBox *activeUserBox=kadu->userbox()->activeUserBox();
	if (activeUserBox==NULL)//to si zdarza...
		return;
	
	UserListElement user = activeUserBox->selectedUsers().first();

	CitySearchResult result;
	if( result.readUserWeatherData( user ) )
	{
		ShowForecastDialog* sfd = new ShowUserForecastDialog( result, user );
		sfd->show();
	}
	else
	{
		GetCityDialog* gcd = new GetUserCityDialog( user );
		gcd->show();
	}
}

void Weather::ShowMyWeather()
{
	CitySearchResult result;
	if( result.readMyWeatherData() )
	{
		ShowForecastDialog* sfd = new ShowMyForecastDialog( result );
		sfd->show();
	}
	else
	{
		GetCityDialog* gcd = new GetMyCityDialog;
		gcd->show();
	}
	
}

void Weather::ShowWeatherFor()
{
	GetCityDialog* gcd = new GetCityDialog;
	gcd->show();
}
