/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SHOW_FORECAST_FRAME_H
#define SHOW_FORECAST_FRAME_H

#include <qframe.h>
#include <qmap.h>
#include "weather_parser.h"
#include "get_forecast.h"
#include "userlistelement.h"
#include "weather_global.h"
#include "search_location_id.h"

class QLabel;
class QHButtonGroup;
class QPopupMenu;
class QVBoxLayout;
class CitySearchResult;

/**
	\class ShowForecastFrame
	Wywietla w okienku prognoz pogody
	pobran za pomoc klasy GetForecast
**/
class ShowForecastFrame : public QFrame
{
	Q_OBJECT
	
	public:
		ShowForecastFrame( QWidget* parent );
		virtual ~ShowForecastFrame() {}
		virtual void start() = 0;
		
	signals:
		void changeCity();
		void dayChanged( int page );
	
	protected:
		QLabel* labelMessage_;
		QLabel* downloadMessage_;
		void start( const CitySearchResult& city );
	
	private:
		Forecast forecast_;
		GetForecast downloader_;
		
		QHButtonGroup* buttonBox_;
		QPopupMenu* contextMenu_;
		QMap<QString,QString> fieldTranslator_;
		
		int currentPage_;
		
		void showForecast();
		void mousePressEvent(QMouseEvent * e);
		const QString& getFieldTranslation( const QString& field );
		void setCurrentPage( int page );
		
	private slots:
		void downloadingFinished();
		void downloadingError(GetForecast::ErrorId err, QString url);
		void dayClicked(int id);
		void menuCopy();
		void menuGoToPage();
};

/**
	\class ShowForecastFrame1
	Wywietla w okienku prognoz pogody
	
**/
class ShowForecastFrame1 : public ShowForecastFrame
{
	public:
		ShowForecastFrame1( QWidget* parent, const CitySearchResult& city );
		virtual ~ShowForecastFrame1() {}
		void start();
	
	private:
		CitySearchResult city_;
		bool started_;
};

/**
	\class ShowForecastFrame2
	Wyszukuje miasto w serwisie i wywietla prognoz pogody
	
**/
class ShowForecastFrame2 : public ShowForecastFrame
{
	Q_OBJECT
	
	public:
		ShowForecastFrame2( QWidget* parent, QString city, QString serverConfigFile );
		virtual ~ShowForecastFrame2() {}
		void start();
	
	private:
		QString city_;
		QString server_;
		SearchLocationID search_;
		bool started_;
	
	private slots:
		void finished();
		void error( QString url );
};

#endif // SHOW_FORECAST_FRAME_H
