
#ifndef PENDING_EVENTS_H
#define PENDING_EVENTS_H

#include <qptrlist.h>
#include "gadu.h"

/**
	Klasa bazowa dla wszystkich kolejkowanych zdarze.
	\class PendingEvent
	\brief Zdarzenia kolejkowane.
**/
class PendingEvent
{
	public:
		/**
			\fn virtual bool sendBy(UinType uin)
			Sprawdza czy zdarzenie dotyczy podanego numeru UIN.
			\param uin numer UIN o ktry pytamy.
			\return warto logiczna informujca czy zdarzenie dotyczy tego numeru UIN czy nie.
		**/
		virtual bool sendBy(UinType uin)=0;

		/**
			\fn virtual void activate()
			Czyni zdarzenie aktywnym.
		**/
		virtual void activate()=0;
};

/**
	\class PendingMessage
	\brief Wiadomo kolejkowana.
**/
class PendingMessage : public PendingEvent
{
	private:
		UinsList Uins;
		QString Msg;
		int MsgClass;
		time_t Time;
		
	public:
		/**
			\fn PendingMessage(const UinsList uins,const QString& msg, const int msg_class,const time_t time)
			Konstruktor tworzcy wiadomo kolejkowan wg. podanych danych.
			\param uins lista numerw UIN od ktrych otrzymano t wiadomo.
			\param msg tre wiadomoci.
			\param msg_class klasa wiadomoci.
			\param time czas wysania wiadomoci.
		**/
		PendingMessage(const UinsList uins,const QString& msg,
			const int msg_class,const time_t time);
		virtual ~PendingMessage();

		/**
			\fn virtual bool sendBy(UinType uin)
			Sprawdza czy zdarzenie dotyczy podanego numeru uin.
			Jest to prawda jesli podany uin jest jednym z
			nadawcow wiadomosci.
			\param uin numer UIN o ktry pytamy.
			\return warto logiczna informujca czy zdarzenie dotyczy tego numeru UIN czy nie.
		**/
		virtual bool sendBy(UinType uin);

		/**
			\fn virtual void activate()
			Aktywuje zdarzenie. Wywietla wiadomo w oknie Chat.
		**/
		virtual void activate();
};

/**
	Klasa bazowa dla wszystkich kolejek zdarze.
	\class PendingEvents
	\brief Kolejki zdarze.
**/
class PendingEvents : public QObject
{
	Q_OBJECT

	private:
		typedef QPtrList<PendingEvent> PendingEventsList;
		PendingEventsList Events;
		
	public:
		/**
			\fn PendingEvents()
			Standardowy konstruktor.
		**/
		PendingEvents();

		/**
			\fn void queueEvent(PendingEvent* event)
			Kolejkuje zdarzenie.
			\param event wskanik do obiektu,
				ktry jest usuwany przez PendingEvents
				podczas aktywacji zdarzenia.
		**/
		void queueEvent(PendingEvent* event);

		/**
			\fn void activateEvent(int index)
			Aktywuje zakolejkowane zdarzenie o podanym indeksie
			i usuwa je z kolejki.
			\param index indeks zdarzenia, ktre ma by aktywowane i usunite.
		**/
		void activateEvent(int index);

		/**
			\fn void activateEvent()
			Aktywuje i usuwa z kolejki pierwsze zakolejkowane
			zdarzenie.
		**/
		void activateEvent();

		/**
			\fn PendingEvent* operator[](int index)
			\param index index zakolejkowanego zdarzenia.
			\return zakolejkowane zdarzenie o podanym indeksie.
		**/
		PendingEvent* operator[](int index);

		/**
			\fn bool pendingEvents(UinType uin)
			Sprawdza czy istniej zakolejkowane zdarzenia
			dotyczce podanego numeru uin.
			\param uin numer UIN o ktry pytamy.
			\return warto logiczna informujca czy istniej zakolejkowane zdarzenia.
		**/
		bool pendingEvents(UinType uin);

		/**
			\fn bool pendingEvents()
			Sprawdza czy istnieja jakiekolwiek zakolejkowane zdarzenia.
			\return warto logiczna informujca czy istniej zakolejkowane zdarzenia.
		**/
		bool pendingEvents();
//		bool loadFromFile();
//		void writeToFile();

	signals:
		/**
			\fn void eventQueued(PendingEvent* event)
			Sygnal emitowany po zakolejkowaniu zdarzenia.
			\param event wskanik do obiektu opisujcego zdarzenie.
		**/
		void eventQueued(PendingEvent* event);

		/**
			\fn void eventActivated(PendingEvent* event)
			Sygnal emitowany po aktywacji zdarzenia i usuniciu
			go z kolejki. Po obsueniu sygnau obiekt jest
			usuwany.
			\param event wskanik do obiektu opisujcego zdarzenie.
		**/
		void eventActivated(PendingEvent* event);
};

extern PendingEvents pending_events;

#endif
