/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * autor
 * Micha Podsiadlik
 * michal at gov.one.pl
 */

#include <qlabel.h>

#include <kadu.h>
#include <message_box.h>
#include <misc.h>
#include <icons_manager.h>

#include "accountdialog.h"

AccountDialog::AccountDialog(Pop3Proto* acc): QDialog(kadu, "account_dialog")
{
	kdebugf();
	setWFlags(Qt::WDestructiveClose);
	setCaption(tr("Account edit"));
	layout=new QGrid(2, Qt::Horizontal, this);
	layout->setMargin(5);
	new QLabel(tr("Accont name"), layout);
	name=new QLineEdit(acc->getName(), layout);
	new QLabel(tr("Server address"), layout);
	host=new QLineEdit(acc->getHost(), layout);
	new QLabel(tr("Port"), layout);
	port=new QSpinBox(0, 65535, 1, layout);
	if(!acc->getPort())
		port->setValue(110);
	else
		port->setValue(acc->getPort());
	new QLabel(tr("Connection type"), layout);
	conntype=new QComboBox(layout);
	conntype->insertItem(tr("No encryption"));
	conntype->insertItem(tr("Encrypted (StartTLS)"));
	conntype->insertItem(tr("Encrypted (immediately)"));
	conntype->setCurrentItem(acc->getEncryption());
	new QLabel(tr("User"), layout);
	user=new QLineEdit(acc->getUser(), layout);
	new QLabel(tr("Password"), layout);
	password=new QLineEdit(acc->getPassword(), layout);
	password->setEchoMode(QLineEdit::Password);
	ok=new QPushButton(icons_manager->loadIcon("OkWindowButton"), tr("OK"), layout);
	cancel=new QPushButton(icons_manager->loadIcon("CancelWindowButton"), tr("Cancel"), layout);
	connect(ok, SIGNAL(clicked()), this, SLOT(save()));
	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	this->acc=acc;
	this->show();
	this->resize(layout->sizeHint());
}

void AccountDialog::save()
{
	kdebugf();
	if(name->text()==""){
		MessageBox::msg(tr("Name of account must be set"));
		return;
	}
	acc->setName(name->text());
	acc->setHost(host->text());
	acc->setPort(port->value());
	acc->setUser(user->text());
	acc->setPassword(password->text());
	acc->setEncryption((SecureType)conntype->currentItem());
	accept();
}

void AccountDialog::resizeEvent(QResizeEvent* e)
{
	layout->resize(e->size());
	QDialog::resizeEvent(e);
}

