#ifndef MIME_TEX_H
#define MIME_TEX_H

#include <qobject.h>
#include <qstringlist.h>

class UserGroup;
class QWidget;

//! This class provides "TeX formula" action
class MimeTeX : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * \brief Default constructor
		 * \param *parent parent object
		 * \param *name object's name
		 */
		MimeTeX(QObject *parent = 0, const char *name = 0);
		
		//! Default destructor
		~MimeTeX();
		
	public slots:
		/*!
		 * \brief Called each time, "TeX formula" actions button is being pressed
		 * \param *group interlocutors
		 * \param *actionButton "TeX formula" actions button
		 * \param activated ignored
		 */
		void TeXActionActivated(const UserGroup *group, const QWidget *actionButton, bool activated);
		
	private slots:
		//! This slot is called when the "PowerKadu" tab is selected in config gialog
		void onCreateTab();
		
	private:
		//! temp files names to be deleted in the destructor
		QStringList tmpFiles;
};

#endif

