#ifndef I_HIDE_FROM_U_H
#define I_HIDE_FROM_U_H

#include <qobject.h>
#include <qstringlist.h>

#include "i_hide_from_u_list.h"
#include "userlistelement.h"

/*!
 * This class provides "I hide from you" mechanism. One only should create
 * an instance of it.
 * \brief Class providing hiding from certain contacts
 */
class IHideFromU : public QObject
{
	Q_OBJECT
	public:
		/*!
		 * \param parent points to patent's object.
		 * \param name is an object's name.
		 * \brief Default constructor
		 */
		IHideFromU(QObject *parent = 0, const char *name = 0);

		//! Default destructor
		~IHideFromU();
	
	protected slots:
		/*!
		 * \brief This slot is called when some contact's status changes
		 * \param elem this user's status is being changed
		 * \param protocolName name of a protocol, that the status is changing for
		 * \param oldStatus previous status
		 * \param massively Unused here
		 * \param last unused here
		 */
		void onUserStatusChangedSlot(UserListElement elem, QString protocolName, const UserStatus &oldStatus,
				bool massively, bool last);
		//! Slot called when the PowerKadu tab is selected in Kadu's configure dialog
		void onCreateTab();

		//! Slot called when the Apply button is pressed in Kadu's configure dialog
		void onApplyTab();

		//! Slot called when the Kadu's configure dialog is being closed
		void onCloseTab();

		//! Slot called when Use "I hide from you" check box is toggled
		void onUseIHideFromUSlot(bool toggled);

		//! Slot called when the contact is being added to the "Selected" listbox
		void onAddSlot();

		//! Slot called when the contact is being removed from the "Selected" listbox
		void onRemoveSlot();

	protected:
		//! Fills the listboxes
		void setListBoxes();

		//! List of selected contacts
		IHideFromUList contacts;

};

#endif
