/***************************************************************************

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***************************************************************************
Copyright (C) 2005 by 
Pan Wojtas (Wojtek Sulewski)
wojteksulewski <at> op.pl
gg: 2087202

***************************************************************************/

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qvgroupbox.h>
#include <qvbuttongroup.h>
#include <qcombobox.h>
#include <qapplication.h> //QApplication::palette()

#include "osdhints_notify.h"

#include "config_dialog.h"
#include "misc.h"
#include "kadu.h"
#include "debug.h"


OSD_Notify *osdhints_notify_module;

extern "C" int osdhints_notify_init()
{
	kdebugf();
	
	osdhints_notify_module = new OSD_Notify();
	
	kdebugf2();
	return 0;
}

extern "C" void osdhints_notify_close()
{
	kdebugf();
	
	delete osdhints_notify_module;

	kdebugf2();
}

OSD_Notify::OSD_Notify()
{
	kdebugf();
	
	createGUI();

// dodaje do notify
	QMap<QString, QString> s;
	s["NewChat"]=SLOT(newChat(Protocol *, UserListElements, const QString &, time_t));
	s["NewMessage"]=SLOT(newMessage(Protocol *, UserListElements, const QString &, time_t, bool &));
	s["ConnError"]=SLOT(connectionError(Protocol *, const QString &));
	s["toAvailable"]=SLOT(userChangedStatusToAvailable(const QString &, UserListElement));
	s["toBusy"]=SLOT(userChangedStatusToBusy(const QString &, UserListElement));
	s["toInvisible"]=SLOT(userChangedStatusToInvisible(const QString &, UserListElement));
	s["toNotAvailable"]=SLOT(userChangedStatusToNotAvailable(const QString &, UserListElement));
	s["UserBoxChangeToolTip"]=SLOT(userBoxChangeToolTip(const QPoint &, UserListElement, bool));
	s["Message"]=SLOT(message(const QString &, const QString &, const QMap<QString, QVariant> *, const UserListElement *));
	
	osd_manager = new OSDManager(NULL, "osdhint_manager");
	notify->registerNotifier(QT_TRANSLATE_NOOP("@default", "osdhints"), osd_manager, s);
	
	kdebugf2();
}

OSD_Notify::~OSD_Notify()
{
	kdebugf();

	notify->unregisterNotifier("osdhints");

	destroyGUI();
	
	delete osd_manager;
	
	kdebugf2();
}

void OSD_Notify::createGUI(void)
{
	kdebugf();
// podgld
	preview = new OSDPreviewWidget(0);
	connect(preview, SIGNAL(positionChanged(int, int)), this, SLOT(preview_positionChanged(int, int)));

// nowy tab w konfiguracji

ConfigDialog::addTab(QT_TRANSLATE_NOOP("@default", "osdhints"), dataPath("kadu/modules/data/osdhints_notify/osd_icon_alt.png"));

	ConfigDialog::addHBox("osdhints", "osdhints", "hints-hbox");
	
		ConfigDialog::addVGroupBox("osdhints", "hints-hbox", QT_TRANSLATE_NOOP("@default", "New OSD"));
		
			ConfigDialog::addVRadioGroup("osdhints", "New OSD", QT_TRANSLATE_NOOP("@default", "New OSD goes"), "NewOSD",
			     toStringList(tr("On top"),tr("Above"),tr("On bottom"),tr("Below"),tr("On the same place")),
			     toStringList("0","1","2","3","4"),"3");
			
			ConfigDialog::addSpinBox("osdhints", "New OSD", "Separator", "OSD_separator", 0, 50, 1, 1);
			ConfigDialog::addCheckBox("osdhints", "New OSD", QT_TRANSLATE_NOOP("@default", "Show emoticons"), "show_emoticons", false);
			ConfigDialog::addSpinBox("osdhints", "New OSD", QT_TRANSLATE_NOOP("@default", "Number of quoted characters"), "CiteSign", 10, 1000, 1, 50);
			
		ConfigDialog::addVGroupBox("osdhints", "hints-hbox", QT_TRANSLATE_NOOP("@default", "Position"));
			ConfigDialog::addVRadioGroup("osdhints", "Position", QT_TRANSLATE_NOOP("@default", "For corner:"), "Corner",
			toStringList(tr("Left top"), tr("Left bottom"), tr("Right top"), tr("Right bottom")),
			toStringList("0", "1", "2", "3"),"3");
			ConfigDialog::addSpinBox("osdhints", "Position", QT_TRANSLATE_NOOP("@default", "X:"), "OSD_x", 0, 3000, 1, 600);
			ConfigDialog::addSpinBox("osdhints", "Position", QT_TRANSLATE_NOOP("@default", "Y:"), "OSD_y", 0, 3000, 1, 400);
	
	ConfigDialog::addVGroupBox("osdhints", "osdhints", QT_TRANSLATE_NOOP("@default", "Mouse buttons"));
		QStringList options=toStringList(tr("Nothing"),tr("Open chat"),tr("Delete hint"),tr("Delete all hints"));
		QStringList values=toStringList("0","1","2","3");
		ConfigDialog::addComboBox("osdhints", "Mouse buttons", QT_TRANSLATE_NOOP("@default", "Left button"), "LeftButton", options, values, "2");
		ConfigDialog::addComboBox("osdhints", "Mouse buttons", QT_TRANSLATE_NOOP("@default", "Middle button"), "MiddleButton", options, values, "3");
		ConfigDialog::addComboBox("osdhints", "Mouse buttons", QT_TRANSLATE_NOOP("@default", "Right button"), "RightButton", options, values, "1");
		
		ConfigDialog::addCheckBox("osdhints", "Mouse buttons", QT_TRANSLATE_NOOP("@default", "Delete pending message when hint deleted"), "DeletePendingMsg", false);

	ConfigDialog::addHGroupBox("osdhints", "osdhints", QT_TRANSLATE_NOOP("@default", "Translucency"));
		ConfigDialog::addCheckBox("osdhints", "Translucency", QT_TRANSLATE_NOOP("@default", "Make the background translucent"), "Use translucency", false);
		ConfigDialog::addSpinBox("osdhints", "Translucency", QT_TRANSLATE_NOOP("@default", "Translucency level"), "Translucency level", 0, 100, 1, 69);

	/* poszczeglne typy */


	ConfigDialog::addVGroupBox("osdhints", "osdhints", QT_TRANSLATE_NOOP("@default", "Parameters"));

		QStringList options2;
		QStringList values2;
		options2<<tr("Online")<<tr("Online (d.)")<<tr("Busy")<<tr("Busy (d.)")<<
				tr("Invisible")<<tr("Invisible (d.)")<<tr("Offline")<<tr("Offline (d.)")<<
				tr("New chat")<<tr("New message in chat")<<tr("Error")<<tr("ToolTip")<<tr("Other message");
		values2<<"0"<<"1"<<"2"<<"3"<<"4"<<"5"<<"6"<<"7"<<"8"<<"9"<<"10"<<"11"<<"12";
		ConfigDialog::addComboBox("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "OSD type"), "LastSelected", options2, values2, "0");
		
		ConfigDialog::addCheckBox("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Set for all"), "SetAll", true);
			

		ConfigDialog::addVGroupBox("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Colors"));
			ConfigDialog::addColorButton("osdhints", "Colors", QT_TRANSLATE_NOOP("@default", "Background color:"), "", QColor("#000000"));
			ConfigDialog::addColorButton("osdhints", "Colors", QT_TRANSLATE_NOOP("@default", "Text color:"), "", QColor("#ffffff"));
			ConfigDialog::addColorButton("osdhints", "Colors", QT_TRANSLATE_NOOP("@default", "Border color:"), "", QColor("#000000"));

		ConfigDialog::addSpinBox("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Duration (0 - stay forever)"), "LastTimeout", 0, 100000, 100, 3600);
		
		ConfigDialog::addSelectFont("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Font in OSD"), "");
		
		QStringList effects = toStringList(tr("Plain"), tr("Dissolve"));
		QStringList effects_values = toStringList("0", "1");
		ConfigDialog::addComboBox("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Show effect:"), "show_effect", effects, effects);
		

		QCString configHint = Kadu::SyntaxText;
		configHint += QT_TRANSLATE_NOOP("@default", "\nOSD: %&m - message, %&f - from (other message only)");
		ConfigDialog::addTextEdit("osdhints", "Parameters", QT_TRANSLATE_NOOP("@default", "Syntax:"), "", QString::null, configHint);


	config_opts_prefixes<<"OSDOnline"<<"OSDOnlineD"<<"OSDBusy"<<"OSDBusyD"<<
					"OSDInvisible"<<"OSDInvisibleD"<<"OSDOffline"<<"OSDOfflineD"<<
					"OSDNewChat"<<"OSDNewMessage"<<"OSDError"<<"OSDToolTip"<<"OSDMessage";
					
		
	config_hint_properties.clear();

	CONST_FOREACH(prefix, config_opts_prefixes)
	{
		OSDProperties prop;
		QFont font(defaultFont->family(), 20);		// def. font
		prop.font = config_file.readFontEntry("osdhints", (*prefix)+"_font", &font);
		prop.fgcolor = config_file.readColorEntry("osdhints", (*prefix)+"_fgcolor", &QApplication::palette().active().highlightedText());
		prop.bgcolor = config_file.readColorEntry("osdhints", (*prefix)+"_bgcolor", &QApplication::palette().active().highlight());
		prop.bordercolor = config_file.readColorEntry("osdhints", (*prefix)+"_bordercolor", &Qt::black);
		prop.timeout = config_file.readUnsignedNumEntry("osdhints", (*prefix)+"_timeout", 3600);
		prop.mask_effect = config_file.readNumEntry("osdhints", (*prefix)+"_mask_effect", 0);
		prop.syntax = config_file.readEntry("osdhints", (*prefix)+"_syntax");
		if (prop.syntax == QString::null)
		{
			if ((*prefix) == "OSDOnline")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/online64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is available") + "</td></tr></table>";
			}
			else if ((*prefix) == "OSDOnlineD")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/online_d64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is available") + "<br><small>%d</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDBusy")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/busy64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is busy") + "</td></tr></table>";
			}
			else if ((*prefix) == "OSDBusyD")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/busy_d64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is busy") + "<br><small>%d</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDInvisible")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/invisible64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is invisible") + "</td></tr></table>";
			}
			else if ((*prefix) == "OSDInvisibleD")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/invisible_d64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is invisible") + "<br><small>%d</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDOffline")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/offline64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is not available") + "</td></tr></table>";
			}
			else if ((*prefix) == "OSDOfflineD")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/offline_d64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>%a</b> is not available") + "<br><small>%d</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDNewChat")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/message64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("Chat with") + "<b> %a</b><br><small>%&m</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDNewMessage")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/message64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("New message from") + "<b> %a</b><br><small>%&m</small></td></tr></table>";
			}
			else if ((*prefix) == "OSDError")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/connection_err_alt64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">" + tr("<b>Error:</b>") + " %&m</td></tr></table>";
			}
			else if ((*prefix) == "OSDToolTip")
			{
				prop.syntax = QT_TRANSLATE_NOOP("@default", "[<i>%s</i><br>][<br><b>Description:</b><br>%d<br><br>][<i>Mobile:</i> <b>%m</b><br>]");
			}
			else if ((*prefix) == "OSDMessage")
			{
				prop.syntax = "<table border=0 cellspacing=0 cellpadding=0><tr><td valign=\"middle\"><img src=\"" + dataPath("kadu/modules/data/osdhints_notify/connection_err_alt64.png") + "\" border=0 align=\"left\"></td><td align=\"right\" valign=\"middle\">%&f%&m</td></tr></table>";
			}
		}

		config_hint_properties[*prefix] = prop;
	}
	
	ConfigDialog::connectSlot("osdhints", "Make the background translucent", SIGNAL(toggled(bool)), this, SLOT(toggled_UseTrans(bool)));
	ConfigDialog::connectSlot("osdhints", "For corner:", SIGNAL(clicked(int)), preview, SLOT(doUpdate()));
	ConfigDialog::connectSlot("osdhints", "OSD type", SIGNAL(activated(int)), this, SLOT(clicked_HintType(int)));
	ConfigDialog::connectSlot("osdhints", "Set for all", SIGNAL(toggled(bool)), this, SLOT(toggled_SetAll(bool)));
	ConfigDialog::connectSlot("osdhints", "Show emoticons", SIGNAL(toggled(bool)), preview, SLOT(doUpdate()));
	ConfigDialog::connectSlot("osdhints", "Duration (0 - stay forever)", SIGNAL(valueChanged(int)), this, SLOT(changed_Timeout(int)));
	ConfigDialog::connectSlot("osdhints", "Font in OSD", SIGNAL(changed(const char *, const QFont&)), this, SLOT(clicked_ChangeFont(const char *, const QFont&)));
	ConfigDialog::connectSlot("osdhints", "Translucency level", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::connectSlot("osdhints", "X:", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::connectSlot("osdhints", "Y:", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::connectSlot("osdhints", "Background color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeBgColor(const char *, const QColor &)));
	ConfigDialog::connectSlot("osdhints", "Text color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeFgColor(const char *, const QColor &)));
	ConfigDialog::connectSlot("osdhints", "Border color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeBorderColor(const char *, const QColor &)));
	ConfigDialog::connectSlot("osdhints", "Show effect:", SIGNAL(activated(int)), this, SLOT(clicked_ShowEffect(int)));
	ConfigDialog::connectSlot("osdhints", "Syntax:", SIGNAL(textChanged()), this, SLOT(changed_syntax()));


	ConfigDialog::registerSlotOnCreateTab("osdhints", this, SLOT(onCreateTab()));
	ConfigDialog::registerSlotsOnTabChange("osdhints", this, SLOT(tabIn()), SLOT(tabOut()));
	ConfigDialog::registerSlotOnCloseTab("osdhints", this, SLOT(tabOut()));
	ConfigDialog::registerSlotOnApplyTab("osdhints", this, SLOT(onApplyConfigDialog()));
	
	kdebugf2();
}

void OSD_Notify::onCreateTab(void)
{
	kdebugf();
	
	ConfigDialog::getSpinBox("osdhints", "Duration (0 - stay forever)")->setSuffix(" ms");
	ConfigDialog::getSpinBox("osdhints", "Translucency level")->setSuffix(" %");
	ConfigDialog::getSpinBox("osdhints", "Separator")->setSuffix(" px");
	
	ConfigDialog::getSpinBox("osdhints", "Translucency level")->setEnabled(ConfigDialog::getCheckBox("osdhints", "Make the background translucent")->isChecked());
	
	kdebugf2();
}

void OSD_Notify::onApplyConfigDialog(void)
{
	kdebugf();
	CONST_FOREACH(prop, config_hint_properties)
	{
		config_file.writeEntry("osdhints", prop.key()+"_font", prop.data().font);
		config_file.writeEntry("osdhints", prop.key()+"_fgcolor", prop.data().fgcolor);
		config_file.writeEntry("osdhints", prop.key()+"_bgcolor", prop.data().bgcolor);
		config_file.writeEntry("osdhints", prop.key()+"_bordercolor", prop.data().bordercolor);
		config_file.writeEntry("osdhints", prop.key()+"_timeout", (int)prop.data().timeout);
		config_file.writeEntry("osdhints", prop.key()+"_mask_effect", prop.data().mask_effect);
		config_file.writeEntry("osdhints", prop.key()+"_syntax", prop.data().syntax);
	}
	
	// reload ustawie
	osd_manager->reload();
	
	kdebugf2();
}

void OSD_Notify::clicked_HintType(int id)
{
	kdebugf();

	currentOptionPrefix = config_opts_prefixes[id];

	OSDProperties prop = config_hint_properties[currentOptionPrefix];

	ConfigDialog::getSelectFont("osdhints", "Font in OSD")->setFont(prop.font);
	ConfigDialog::getSpinBox("osdhints", "Duration (0 - stay forever)")->setValue(prop.timeout);
	ConfigDialog::getColorButton("osdhints", "Background color:")->setColor(prop.bgcolor);
	ConfigDialog::getColorButton("osdhints", "Text color:")->setColor(prop.fgcolor);
	ConfigDialog::getColorButton("osdhints", "Border color:")->setColor(prop.bordercolor);
	ConfigDialog::getComboBox("osdhints", "Show effect:")->setCurrentItem(prop.mask_effect);
	ConfigDialog::getTextEdit("osdhints", "Syntax:")->setText(prop.syntax);

	kdebugf2();
}

void OSD_Notify::toggled_SetAll(bool val)
{
	kdebugf();
	
	if (val)
	{
		CONST_FOREACH(prefix, config_opts_prefixes)
		{
			OSDProperties prop;

			prop.font = config_hint_properties[currentOptionPrefix].font;
			prop.fgcolor = config_hint_properties[currentOptionPrefix].fgcolor;
			prop.bgcolor = config_hint_properties[currentOptionPrefix].bgcolor;
			prop.bordercolor = config_hint_properties[currentOptionPrefix].bordercolor;
			prop.timeout = config_hint_properties[currentOptionPrefix].timeout;
			prop.mask_effect = config_hint_properties[currentOptionPrefix].mask_effect;
			prop.syntax =  config_hint_properties[*prefix].syntax;		// skadnia si nie zmienia!
	
			config_hint_properties[*prefix]=prop;
		}
	}
	
	kdebugf2();
}

void OSD_Notify::clicked_ChangeFont(const char *, const QFont& font)
{
	kdebugf();
	
	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().font = font;
	else
		config_hint_properties[currentOptionPrefix].font = font;

	preview->doUpdate();
	
	kdebugf2();
}

void OSD_Notify::clicked_ChangeFgColor(const char *, const QColor &value)
{
	kdebugf();

	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().fgcolor = value;
	else
		config_hint_properties[currentOptionPrefix].fgcolor = value;
	
	preview->doUpdate();

	kdebugf2();
}

void OSD_Notify::clicked_ChangeBgColor(const char *, const QColor &value)
{
	kdebugf();

	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().bgcolor = value;
	else
		config_hint_properties[currentOptionPrefix].bgcolor = value;

	preview->doUpdate();

	kdebugf2();
}

void OSD_Notify::clicked_ChangeBorderColor(const char *, const QColor &value)
{
	kdebugf();

	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().bordercolor = value;
	else
		config_hint_properties[currentOptionPrefix].bordercolor = value;

	preview->doUpdate();

	kdebugf2();
}

void OSD_Notify::changed_Timeout(int value)
{
	kdebugf();

	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().timeout = value;
	else
		config_hint_properties[currentOptionPrefix].timeout = value;

	kdebugf2();
}

void OSD_Notify::clicked_ShowEffect(int val)
{
	kdebugf();

	if (ConfigDialog::getCheckBox("osdhints", "Set for all")->isChecked())
		FOREACH(prop, config_hint_properties)
				prop.data().mask_effect = val;
	else
		config_hint_properties[currentOptionPrefix].mask_effect = val;
	
	preview->doUpdate();

	kdebugf2();
}

void OSD_Notify::changed_syntax()
{
	kdebugf();

	config_hint_properties[currentOptionPrefix].syntax = ConfigDialog::getTextEdit("osdhints", "Syntax:")->text();
	
	preview->doUpdate();

	kdebugf2();
}

void OSD_Notify::toggled_UseTrans(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getSpinBox("osdhints", "Translucency level")->setEnabled(toggled);
	
	preview->doUpdate();
	
	kdebugf2();
}

void OSD_Notify::preview_positionChanged(int x, int y)
{
	kdebugf();

	ConfigDialog::getSpinBox("osdhints", "X:")->setValue(x);
	ConfigDialog::getSpinBox("osdhints", "Y:")->setValue(y);
	
	preview->doUpdate();
	
	kdebugf2();
}

void OSD_Notify::tabIn(void)
{
	kdebugf();
	
	clicked_HintType(ConfigDialog::getComboBox("osdhints", "OSD type")->currentItem());
	
///	preview->QWidget::show();
	
	kdebugf2();
}

void OSD_Notify::tabOut(void)
{
	kdebugf();
	
	preview->QWidget::hide();
	
	kdebugf2();
}

void OSD_Notify::destroyGUI(void)
{
	kdebugf();
	
	ConfigDialog::unregisterSlotOnCreateTab("osdhints", this, SLOT(onCreateTab()));
	ConfigDialog::unregisterSlotsOnTabChange("osdhints", this, SLOT(tabIn()), SLOT(tabOut()));
	ConfigDialog::unregisterSlotOnCloseTab("osdhints", this, SLOT(tabOut()));
	ConfigDialog::unregisterSlotOnApplyTab("osdhints", this, SLOT(onApplyConfigDialog()));

	ConfigDialog::disconnectSlot("osdhints", "Make the background translucent", SIGNAL(toggled(bool)), this, SLOT(toggled_UseTrans(bool)));
	ConfigDialog::disconnectSlot("osdhints", "For corner:", SIGNAL(clicked(int)), preview, SLOT(doUpdate()));
	ConfigDialog::disconnectSlot("osdhints", "OSD type", SIGNAL(activated(int)), this, SLOT(clicked_HintType(int)));
	ConfigDialog::disconnectSlot("osdhints", "Set for all", SIGNAL(toggled(bool)), this, SLOT(toggled_SetAll(bool)));
	ConfigDialog::disconnectSlot("osdhints", "Show emoticons", SIGNAL(toggled(bool)), preview, SLOT(doUpdate()));
	ConfigDialog::disconnectSlot("osdhints", "Duration (0 - stay forever)", SIGNAL(valueChanged(int)), this, SLOT(changed_Timeout(int)));
	ConfigDialog::disconnectSlot("osdhints", "Font in OSD", SIGNAL(changed(const char *, const QFont&)), this, SLOT(clicked_ChangeFont(const char *, const QFont&)));
	ConfigDialog::disconnectSlot("osdhints", "Translucency level", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::disconnectSlot("osdhints", "X:", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::disconnectSlot("osdhints", "Y:", SIGNAL(valueChanged(int)), preview, SLOT(doUpdate()));
	ConfigDialog::disconnectSlot("osdhints", "Background color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeBgColor(const char *, const QColor &)));
	ConfigDialog::disconnectSlot("osdhints", "Text color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeFgColor(const char *, const QColor &)));
	ConfigDialog::disconnectSlot("osdhints", "Border color:", SIGNAL(changed(const char *, const QColor &)), this, SLOT(clicked_ChangeBorderColor(const char *, const QColor &)));
	ConfigDialog::disconnectSlot("osdhints", "Show effect:", SIGNAL(activated(int)), this, SLOT(clicked_ShowEffect(int)));
	ConfigDialog::disconnectSlot("osdhints", "Syntax:", SIGNAL(textChanged()), this, SLOT(changed_syntax()));
	

	ConfigDialog::removeControl("osdhints", "Syntax:");
	ConfigDialog::removeControl("osdhints", "Show effect:");
	ConfigDialog::removeControl("osdhints", "Font in OSD");
	ConfigDialog::removeControl("osdhints", "Duration (0 - stay forever)");
	ConfigDialog::removeControl("osdhints", "Border color:");
	ConfigDialog::removeControl("osdhints", "Text color:");
	ConfigDialog::removeControl("osdhints", "Background color:");
	ConfigDialog::removeControl("osdhints", "Colors");
	ConfigDialog::removeControl("osdhints", "Set for all");
	ConfigDialog::removeControl("osdhints", "OSD type");
	ConfigDialog::removeControl("osdhints", "Parameters");
	ConfigDialog::removeControl("osdhints", "Translucency level");
	ConfigDialog::removeControl("osdhints", "Make the background translucent");
	ConfigDialog::removeControl("osdhints", "Translucency");
	ConfigDialog::removeControl("osdhints", "Delete pending message when hint deleted");
	ConfigDialog::removeControl("osdhints", "Right button");
	ConfigDialog::removeControl("osdhints", "Middle button");
	ConfigDialog::removeControl("osdhints", "Left button");
	ConfigDialog::removeControl("osdhints", "Mouse buttons");
	ConfigDialog::removeControl("osdhints", "Y:");
	ConfigDialog::removeControl("osdhints", "X:");
	ConfigDialog::removeControl("osdhints", "For corner:");
	ConfigDialog::removeControl("osdhints", "Position");
	ConfigDialog::removeControl("osdhints", "Number of quoted characters");
	ConfigDialog::removeControl("osdhints", "Show emoticons");
	ConfigDialog::removeControl("osdhints", "Separator");
	ConfigDialog::removeControl("osdhints", "New OSD goes");
	ConfigDialog::removeControl("osdhints", "New OSD");
	ConfigDialog::removeControl("osdhints", "hints-hbox");
	
	ConfigDialog::removeTab("osdhints");
	
	disconnect(preview, SIGNAL(positionChanged(int, int)), this, SLOT(preview_positionChanged(int, int)));
	delete preview;

	kdebugf2();
}
