/**********************************************************
 * MODULE:    mysql
 * AUTHOR(S): Radim Blazek (radim.blazek@gmail.com)
 * PURPOSE:   MySQL database driver
 * COPYRIGHT: (C) 2001 by the GRASS Development Team
 *            This program is free software under the 
 *            GNU General Public License (>=v2). 
 *            Read the file COPYING that comes with GRASS
 *            for details.
 **********************************************************/
#include <stdio.h>

#include <grass/gis.h>
#include <grass/dbmi.h>
#include <grass/glocale.h>

#include "globals.h"
#include "proto.h"

/* init error message */
void
init_error ( void )
{
    if ( !errMsg ) {
	errMsg = (dbString *) G_malloc(sizeof(dbString));
        db_init_string (errMsg);
    }

    db_set_string ( errMsg, _("DBMI-MySQL driver error:\n") );
}

/* append error message */
void
append_error ( const char *msg )
{
    db_append_string ( errMsg, (char *)msg);
}

void
report_error ( void )
{
    db_append_string ( errMsg, "\n");
    db_error ( db_get_string (errMsg) );
}

